\name{vacs_2_0_index}
\alias{vacs_2_0_index}
\title{
Veterans Aging Cohort Study (VACS) 2.0 Index
}
\description{
Calculates the VACS Index 2.0 score to estimate the risk of 5-year all-cause mortality in patients with HIV. This updated model incorporates additional variables (albumin, WBC, BMI) and uses continuous functions for laboratory values to improve predictive accuracy over the original VACS Index 1.0.
}
\usage{
vacs_2_0_index(age, cd4_count, hiv_rna, hemoglobin, fib4_index, egfr,
               hepatitis_c_positive, albumin, wbc_count, bmi,
               sex = "male", race = "other")
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{cd4_count}{
Numeric. CD4 T-cell count (cells/mm^3).
}
  \item{hiv_rna}{
Numeric. HIV-1 RNA viral load (copies/mL).
}
  \item{hemoglobin}{
Numeric. Hemoglobin level (g/dL).
}
  \item{fib4_index}{
Numeric. FIB-4 Index for Liver Fibrosis.
}
  \item{egfr}{
Numeric. Estimated Glomerular Filtration Rate (mL/min/1.73m^2).
}
  \item{hepatitis_c_positive}{
Numeric (0 or 1). Hepatitis C virus (HCV) status (1 = Positive).
}
  \item{albumin}{
Numeric. Serum Albumin level (g/dL).
}
  \item{wbc_count}{
Numeric. White Blood Cell count (x10^3/uL).
}
  \item{bmi}{
Numeric. Body Mass Index (kg/m^2).
}
  \item{sex}{
String. Patient sex ("male" or "female"). (Not explicitly weighted in published general model but typically collected).
}
  \item{race}{
String. Patient race ("black", "other"). (Not explicitly weighted in published general model but typically collected).
}
}
\value{
A list containing:
\item{VACS_2_0_Index}{The calculated risk score (higher scores indicate greater mortality risk).}
\item{Est_5_Year_Mortality}{Estimated probability of 5-year all-cause mortality.}
}
\references{
Tate JP, et al. An internationally generalizable risk index for mortality after one year of antiretroviral therapy. AIDS. 2013;27(4):563-572.
Justice AC, et al. A prognostic index for HIV-associated mortality.
}
\examples{

# Example 1: Low Risk
# 40yo, CD4 600, VL 50, Hgb 15, FIB4 1.0, eGFR 100, HCV-, Alb 4.2, WBC 6.0, BMI 26
vacs_2_0_index(40, 600, 50, 15, 1.0, 100, 0, 4.2, 6.0, 26)

# Example 2: High Risk
# 60yo, CD4 200, VL 50000, Hgb 11, FIB4 3.5, eGFR 45, HCV+, Alb 3.0, WBC 4.0, BMI 22
vacs_2_0_index(60, 200, 50000, 11, 3.5, 45, 1, 3.0, 4.0, 22)
}
