\name{virsta_score}
\alias{virsta_score}
\title{
VIRSTA Score for Infective Endocarditis
}
\description{
Calculates the VIRSTA score to predict the risk of Infective Endocarditis (IE) in patients with Staphylococcus aureus bacteremia. The score helps identify patients at low risk for whom Transesophageal Echocardiography (TEE) might be safely avoided.
}
\usage{
virsta_score(cerebral_emboli, meningitis, permanent_intracardiac_device,
             history_infective_endocarditis, vertebral_osteomyelitis,
             preexisting_native_valve_disease, intravenous_drug_use,
             severe_sepsis_shock, crp_mg_l, community_acquired)
}
\arguments{
  \item{cerebral_emboli}{
Numeric (0 or 1). Presence of cerebral emboli (clinical or imaging). (1 = Yes, +5 points).
}
  \item{meningitis}{
Numeric (0 or 1). Presence of meningitis. (1 = Yes, +4 points).
}
  \item{permanent_intracardiac_device}{
Numeric (0 or 1). Presence of a permanent intracardiac device (e.g., prosthetic valve, pacemaker, ICD). (1 = Yes, +4 points).
}
  \item{history_infective_endocarditis}{
Numeric (0 or 1). Previous history of infective endocarditis. (1 = Yes, +3 points).
}
  \item{vertebral_osteomyelitis}{
Numeric (0 or 1). Presence of vertebral osteomyelitis. (1 = Yes, +3 points).
}
  \item{preexisting_native_valve_disease}{
Numeric (0 or 1). Pre-existing native valve disease. (1 = Yes, +3 points).
}
  \item{intravenous_drug_use}{
Numeric (0 or 1). Intravenous drug use. (1 = Yes, +2 points).
}
  \item{severe_sepsis_shock}{
Numeric (0 or 1). Presence of severe sepsis or septic shock. (1 = Yes, +1 point).
}
  \item{crp_mg_l}{
Numeric. C-Reactive Protein level in mg/L. (>= 190 mg/L adds +2 points).
}
  \item{community_acquired}{
Numeric (0 or 1). Is the bacteremia community-acquired? (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{VIRSTA_Score}{The calculated total score.}
\item{Risk_Category}{Risk classification (Low vs. High).}
\item{Recommendation}{Clinical guidance regarding the need for TEE.}
}
\references{
Delahaye F, et al. Prediction of Infective Endocarditis in Patients with Staphylococcus aureus Bacteremia: The VIRSTA Score. J Am Coll Cardiol. 2016;67(20):2305-2314.
}
\examples{

# Example 1: High Risk
# Pacemaker (+4), Fever/Sepsis (+1), Community Acquired (+1) -> Score 6
virsta_score(0, 0, 1, 0, 0, 0, 0, 1, 50, 1)

# Example 2: Low Risk
# Community Acquired (+1), CRP 100 (0), No other factors -> Score 1
virsta_score(0, 0, 0, 0, 0, 0, 0, 0, 100, 1)
}
