\name{winters_formula}
\alias{winters_formula}
\title{
Winter's Formula for Metabolic Acidosis Compensation
}
\description{
Calculates the expected partial pressure of carbon dioxide (PaCO2) in the setting of metabolic acidosis to determine if the respiratory compensation is appropriate. If the measured PaCO2 falls outside the calculated range, a concomitant respiratory disorder exists.
}
\usage{
winters_formula(bicarbonate, measured_paco2 = NULL)
}
\arguments{
  \item{bicarbonate}{
Numeric. The serum bicarbonate (HCO3) level in mEq/L or mmol/L.
}
  \item{measured_paco2}{
Numeric (Optional). The measured arterial PaCO2 in mmHg. If provided, the function evaluates whether a mixed acid-base disorder is present.
}
}
\details{
The formula used is:
\deqn{Expected PaCO_2 = (1.5 \times HCO_3) + 8 \pm 2}

Interpretation of results when PaCO2 is provided:
\itemize{
  \item \strong{Within Range}: Pure metabolic acidosis with appropriate respiratory compensation.
  \item \strong{< Lower Limit}: Concomitant Respiratory Alkalosis.
  \item \strong{> Upper Limit}: Concomitant Respiratory Acidosis.
}
}
\value{
A list containing:
\item{Expected_PaCO2_Range_mmHg}{The range of expected PaCO2 values.}
\item{Interpretation}{Analysis of the compensation status based on the measured PaCO2.}
}
\references{
Albert MS, Dell RB, Winters RW. Quantitative displacement of acid-base equilibrium in metabolic acidosis. Ann Intern Med. 1967;66(2):312-322. doi:10.7326/0003-4819-66-2-312
}
\examples{

# Example 1: Compensated Metabolic Acidosis
# HCO3 = 14, PaCO2 = 29
# Exp = (1.5 * 14) + 8 = 29 +/- 2 = 27-31
winters_formula(14, 29)

# Example 2: Concomitant Respiratory Acidosis
# HCO3 = 14, PaCO2 = 35 (Higher than expected range 27-31)
winters_formula(14, 35)
}
