% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracts_to_h3.R
\name{tracts_to_h3}
\alias{tracts_to_h3}
\title{Convert census tract aggregates to an H3 grid using CNEFE points}
\usage{
tracts_to_h3(
  code_muni,
  year = 2022,
  h3_resolution = 9,
  vars = c("pop_ph", "pop_ch"),
  cache = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{code_muni}{Integer. Seven-digit IBGE municipality code.}

\item{year}{Integer. The CNEFE data year. Currently only 2022 is supported.
Defaults to 2022.}

\item{h3_resolution}{Integer. H3 resolution (0 to 15). Defaults to 9.}

\item{vars}{Character vector. Names of tract-level variables to interpolate.
Supported variables:
\itemize{
\item \code{pop_ph}: population in private households (\emph{Domicílios particulares}).
\item \code{pop_ch}: population in collective households (\emph{Domicílios coletivos}).
\item \code{male}: total male population.
\item \code{female}: total female population.
\item \code{age_0_4}, \code{age_5_9}, \code{age_10_14}, \code{age_15_19}, \code{age_20_24}, \code{age_25_29},
\code{age_30_39}, \code{age_40_49}, \code{age_50_59}, \code{age_60_69}, \code{age_70m}: population by age group.
\item \code{race_branca}, \code{race_preta}, \code{race_amarela}, \code{race_parda}, \code{race_indigena}:
population by race/color (\emph{cor ou raça}).
\item \code{n_resp}: number of household heads (\emph{Pessoas responsáveis por domicílios}).
\item \code{avg_inc_resp}: average income of the household heads.
}

For a reference table mapping these variable names to the official IBGE
census tract codes and descriptions, see \link{tracts_variables_ref}.

Allocation rules:
\itemize{
\item \code{pop_ph} is allocated only to private dwellings.
\item \code{pop_ch} is allocated only to collective dwellings.
\item \code{n_resp} is allocated only to private dwellings (same rule as \code{pop_ph}).
\item Demographic variables (\code{male}, \code{female}, \verb{age_*}, \verb{race_*}) are allocated
to private dwellings when the tract has any; if the tract has zero private
dwellings but has collective dwellings, they are allocated to collective.
\item \code{avg_inc_resp} is assigned (not split) to each private dwelling point;
tracts with no private dwellings receive no allocation.
}}

\item{cache}{Logical. Whether to use the existing package cache for assets and CNEFE zips.}

\item{verbose}{Logical. Whether to print step messages and timing.}
}
\value{
An \code{sf} object (CRS 4326) with an H3 grid and the requested interpolated variables.
}
\description{
\code{tracts_to_h3()} performs a dasymetric interpolation with the following steps:
\enumerate{
\item census tract totals are allocated to CNEFE dwelling points inside each tract;
\item allocated values are aggregated to an H3 grid at a user-defined resolution.
}

The function uses DuckDB with the spatial and H3 extensions for the heavy work.
}
\examples{
\donttest{
# Interpolate population to H3 hexagons
hex_pop <- tracts_to_h3(
  code_muni = 2929057,
  vars = c("pop_ph", "pop_ch")
)
}

}
