% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patterns.R
\name{discover_patterns}
\alias{discover_patterns}
\title{Discover Sequence Patterns}
\usage{
discover_patterns(
  data,
  type = "ngram",
  pattern,
  len = 2:5,
  gap = 1:3,
  min_support = 0.01,
  min_count = 2,
  start,
  end,
  contains
)
}
\arguments{
\item{data}{[\code{data.frame}, \code{matrix}, \code{stslist}]\cr
Sequence data in wide format (rows are sequences, columns are time points).}

\item{type}{[\code{character(1)}]\cr Type of pattern analysis:
\itemize{
\item \code{"ngram"}: Extract contiguous n-grams.
\item \code{"gapped"}: Discover patterns with gaps/wildcards.
\item \code{"repeated"}: Detect repeated occurrences of the same state.
}}

\item{pattern}{[\code{character(1)}]\cr Specific pattern to search for as
a character string (e.g., \code{"A->*->B"}). If provided, \code{type} is ignored.
Supports wildcards: \code{*} (single) and \verb{**} (multi-wildcard).}

\item{len}{[\code{integer()}]\cr Pattern lengths to consider for
n-grams and repeated patterns (default: \code{2:5}).}

\item{gap}{[\code{integer()}]\cr Gap sizes to consider for
gapped patterns (default: \code{1:3}).}

\item{min_support}{[\code{integer(1)}]\cr Minimum support threshold, i.e., the
proportion of sequences that must contain a specific pattern for it to
be included (default: \code{0.01}).}

\item{min_count}{[\code{integer(1)}]\cr Minimum count threshold, i.e., the
numbers of times a pattern must occur across all sequences for it to
be included (default: \code{2}).}

\item{start}{[\code{character(1)}]\cr Filter patterns starting with these states.}

\item{end}{[\code{character(1)}]\cr Filter patterns ending with these states.}

\item{contains}{[\code{character(1)}]\cr Filter patterns containing these states.}
}
\value{
A \code{tibble} containing the discover patterns, counts, proportions,
and support.
}
\description{
Discovering various types of patterns in sequence data.
Provides n-gram extraction, gapped pattern discovery, analysis of repeated
patterns and targeted pattern search.
}
\examples{
# N-grams
ngrams <- discover_patterns(engagement, type = "ngram")

# Gapped patterns
gapped <- discover_patterns(engagement, type = "gapped")

# Repeated patterns
repeated <- discover_patterns(engagement, type = "repeated")

# Custom pattern with a wildcard state
custom <- discover_patterns(engagement, pattern = "Active->*")

}
