% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting.R
\name{reportMeanAndSD}
\alias{reportMeanAndSD}
\title{Report the mean and standard deviation of a dependent variable for all levels of an independent variable rounded to the 2nd digit.}
\usage{
reportMeanAndSD(data, iv = "testiv", dv = "testdv")
}
\arguments{
\item{data}{the data frame}

\item{iv}{the independent variable}

\item{dv}{the dependent variable}
}
\value{
Mean and SD values
}
\description{
#' To easily copy and paste the results to your manuscript, the following commands must be defined in Latex:
\code{\\newcommand{\\m}{\\textit{M=}}}
\code{\\newcommand{\\sd}{\\textit{SD=}}}
}
\examples{
\donttest{

example_data <- data.frame(Condition = rep(c("A", "B", "C"),
each = 10), TLX1 = stats::rnorm(30))

reportMeanAndSD(example_data, iv = "Condition", dv = "TLX1")
}
}
