% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting.R
\name{latexify_report}
\alias{latexify_report}
\title{Transform text from \code{report::report()} into LaTeX-friendly output.}
\usage{
latexify_report(
  x,
  print_result = TRUE,
  only_sig = FALSE,
  remove_std = FALSE,
  itemize = TRUE
)
}
\arguments{
\item{x}{Character vector or a single string containing the report text.}

\item{print_result}{Logical. If \code{TRUE} (default), the formatted text is printed to the console.}

\item{only_sig}{Logical. If \code{TRUE}, bullet items containing "non-significant" are omitted. Default is \code{FALSE}.}

\item{remove_std}{Logical. If \code{TRUE}, the final standardized parameters note is removed. Default is \code{FALSE}.}

\item{itemize}{Logical. If \code{TRUE} (default), bullet items are wrapped in a LaTeX \code{itemize} environment;
otherwise the bullet markers are simply removed.}
}
\value{
A single string with the LaTeX-friendly formatted report text.
}
\description{
This function transforms the text output from \code{report::report()} by performing several substitutions
to prepare the text for LaTeX typesetting. In particular, it replaces instances of \code{R2}, \verb{\%}, and \code{~} with
the corresponding LaTeX code. Additionally, it provides options to:
\itemize{
\item Omit bullet items marked as "non-significant" (when \code{only_sig = TRUE}).
\item Remove a concluding note about standardized parameters (when \code{remove_std = TRUE}).
\item Wrap bullet items in a LaTeX \code{itemize} environment or leave them as plain text (controlled by \code{itemize}).
}
}
\examples{
\donttest{
if (requireNamespace("report", quietly = TRUE)) {
  # Simple linear model on the iris dataset
  model <- stats::lm(
    Sepal.Length ~ Sepal.Width + Petal.Length,
    data = datasets::iris
  )

  # Format the report output, showing only significant items, removing the
  # standard note, and wrapping bullet items in an itemize environment.
  report_text <- try(report::report(model), silent = TRUE)
  if (!inherits(report_text, "try-error")) {
    latexify_report(
      report_text,
      only_sig = TRUE,
      remove_std = TRUE,
      itemize = TRUE
    )
  }
}
}
}
