% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/color_plane.R
\name{alpha_channel}
\alias{alpha_channel}
\alias{alpha_channel,HexColorPlane-method}
\alias{alpha_channel,ConstantColorPlane-method}
\alias{alpha_channel,RGBColorPlane-method}
\title{alpha_channel}
\usage{
alpha_channel(x, ...)

\S4method{alpha_channel}{HexColorPlane}(x, normalize = TRUE)

\S4method{alpha_channel}{ConstantColorPlane}(x, normalize = TRUE)

\S4method{alpha_channel}{RGBColorPlane}(x, normalize = TRUE)
}
\arguments{
\item{x}{the object to extract alpha channel from}

\item{...}{extra args}

\item{normalize}{divide by 255}
}
\value{
a numeric vector of alpha channel values
}
\description{
extract the alpha channel
}
\examples{
cp <- IntensityColorPlane(seq(1,5), cols=rainbow(25))
cl <- map_colors(cp, irange=c(0,50))
stopifnot(length(alpha_channel(cl)) == 5)
}
