% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/width.R
\name{width}
\alias{width}
\alias{print.width}
\title{Calculate interval forecast width}
\usage{
width(
  object,
  ...,
  level = 95,
  includemedian = FALSE,
  window = NULL,
  na.rm = FALSE
)
}
\arguments{
\item{object}{An object of class \code{"cvforecast"} or \code{"cpforecast"}.}

\item{...}{Additional inputs if \code{object} is missing.}

\item{level}{Target confidence level for prediction intervals.}

\item{includemedian}{If \code{TRUE}, the median interval width will also be returned.}

\item{window}{If not \code{NULL}, the rolling mean (and rolling median if applicable)
matrix for interval width will also be returned.}

\item{na.rm}{A logical indicating whether \code{NA} values should be stripped
before the rolling mean and rolling median computation proceeds.}
}
\value{
A list of class \code{"width"} with the following components:
\item{width}{Forecast interval width as a multivariate time series, where the \eqn{h}th
column holds the interval width for the forecast horizon \eqn{h}. The time index
corresponds to the period for which the forecast is produced.}
\item{mean}{Mean interval width across the validation set.}
\item{rollmean}{If \code{window} is not NULL, a matrix of the rolling means
of interval width will be returned.}
\item{median}{Median interval width across the validation set.}
\item{rollmedian}{If \code{window} is not NULL, a matrix of the rolling medians
of interval width will be returned.}
}
\description{
Calculate the mean width of prediction intervals on the validation set.
If \code{window} is not \code{NULL}, a matrix of the rolling means of interval
width is also returned. If \code{includemedian} is \code{TRUE},
the information of the median interval width will be returned.
}
\examples{
# Simulate time series from an AR(2) model
library(forecast)
series <- arima.sim(n = 200, list(ar = c(0.8, -0.5)), sd = sqrt(1))

# Cross-validation forecasting with a rolling window
far2 <- function(x, h, level) {
  Arima(x, order = c(2, 0, 0)) |>
    forecast(h = h, level)
}
fc <- cvforecast(series, forecastfun = far2, h = 3, level = 95,
                 forward = TRUE, initial = 1, window = 50)

# Mean and rolling mean width for interval forecasts on validation set
wid_fc <- width(fc, level = 95, window = 50)
str(wid_fc)

}
