% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lists.R
\name{list_surveys}
\alias{list_surveys}
\title{List all surveys available for download}
\usage{
list_surveys(
  directory = tempdir(),
  overwrite = FALSE,
  verbose = TRUE,
  rate = purrr::rate_backoff(pause_base = 5, max_times = 4)
)
}
\arguments{
\item{directory}{Directory to save the cached survey list. Defaults to
\code{\link[=tempdir]{tempdir()}}, so the cached list does not persist across R sessions. For
persistent caching, pass \code{\link[=contactsurveys_dir]{contactsurveys_dir()}}.}

\item{overwrite}{If files should be overwritten if they already exist.
Default FALSE}

\item{verbose}{Whether downloads should be echoed to output. Default TRUE.}

\item{rate}{a
\href{https://purrr.tidyverse.org/reference/rate-helpers.html}{purrr rate}
object, to facilitate downloading if the download fails. Defaults to an
exponential backoff of 5 seconds (up to 4 attempts: 1 initial + 3 retries)
changed by specifying your own rate object, see \code{?purrr::rate_backoff()}
for details.}
}
\value{
data.table with columns: date_added, title, creator, url
}
\description{
List all surveys available for download
}
\examples{
\donttest{
list_surveys()
}
}
