% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cto_form_files.R
\name{cto_form_languages}
\alias{cto_form_languages}
\alias{cto_form_stata_template}
\alias{cto_form_printable}
\alias{cto_form_mail_template}
\title{Download SurveyCTO Form Files and Templates}
\usage{
cto_form_languages(form_id)

cto_form_stata_template(
  form_id,
  dir = getwd(),
  lang = NULL,
  csv_dir = NULL,
  dta_dir = NULL
)

cto_form_printable(
  form_id,
  dir = getwd(),
  lang = NULL,
  relevancies = FALSE,
  constraints = FALSE
)

cto_form_mail_template(form_id, dir = getwd(), type = 2, group_names = FALSE)
}
\arguments{
\item{form_id}{A character string giving the unique SurveyCTO form ID.}

\item{dir}{A character string specifying the directory where downloaded files
will be saved. Defaults to the current working directory.}

\item{lang}{Optional character string giving the language identifier
(for example, \code{"English"}). If \code{NULL}, the form's default language is used.}

\item{csv_dir}{Optional character string giving the directory where the CSV
dataset will eventually be stored. This value is embedded in the generated
Stata \code{.do} file to automate data loading.}

\item{dta_dir}{Optional character string giving the directory where the Stata
\code{.dta} file should be written by the template.}

\item{relevancies}{Logical; if \code{TRUE}, relevance logic (skip patterns) is
included in the printable form. Defaults to \code{FALSE}.}

\item{constraints}{Logical; if \code{TRUE}, constraint logic is included in the
printable form. Defaults to \code{FALSE}.}

\item{type}{Integer (0–2) specifying the format of the mail merge template:
\itemize{
\item \code{0}: Field names only.
\item \code{1}: Field labels only.
\item \code{2}: Both field names and labels.
}}

\item{group_names}{Logical; if \code{TRUE}, group names are included in variable
headers. Defaults to \code{FALSE}.}
}
\value{
\itemize{
\item \strong{\code{cto_form_languages()}} returns a list containing the available languages
and the index of the default language (1-based).
\item All other functions return the local file path of the downloaded file,
invisibly.
}
}
\description{
These functions retrieve auxiliary files and templates associated with a
deployed SurveyCTO form. All these functions require a stateful session to work.
\itemize{
\item \code{\link[=cto_form_languages]{cto_form_languages()}} retrieves the list of languages defined in the form.
\item \code{\link[=cto_form_stata_template]{cto_form_stata_template()}} downloads a Stata \code{.do} file template for
importing submitted data.
\item \code{\link[=cto_form_printable]{cto_form_printable()}} downloads a printable (HTML) version of the form
definition.
\item \code{\link[=cto_form_mail_template]{cto_form_mail_template()}} downloads a mail merge template for the form.
}

All downloads are saved locally and their file paths are returned invisibly.
}
\examples{
\dontrun{
form <- "household_survey"

# 1. List available form languages
langs <- cto_form_languages(form)
print(langs)

# 2. Download a Stata import template
# Provide future CSV/DTA locations so the .do file is ready to run
cto_form_stata_template(
  form_id = form,
  dir     = "downloads/",
  csv_dir = "C:/Data",
  dta_dir = "C:/Data"
)

# 3. Download a printable form with logic displayed
cto_form_printable(
  form_id      = form,
  dir          = "documentation/",
  relevancies  = TRUE,
  constraints  = TRUE
)

# 4. Download a mail-merge template
cto_form_mail_template(
  form_id = form,
  dir     = "templates/",
  type    = 2
)
}
}
\seealso{
Other Form Management Functions: 
\code{\link{cto_form_attachment}()},
\code{\link{cto_form_data}()},
\code{\link{cto_form_data_attachment}()},
\code{\link{cto_form_dofile}()},
\code{\link{cto_form_metadata}()}
}
\concept{Form Management Functions}
