% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cto_metadata.R
\name{cto_metadata}
\alias{cto_metadata}
\alias{cto_form_ids}
\alias{cto_group_list}
\alias{cto_team_list}
\alias{cto_role_list}
\alias{cto_user_list}
\title{Retrieve Server Metadata and Resource Lists}
\usage{
cto_form_ids()

cto_metadata(which = c("all", "datasets", "forms", "groups"))

cto_group_list(
  order_by = c("createdOn", "id", "title"),
  sort = c("ASC", "DESC"),
  parent_group_id = NULL
)

cto_team_list()

cto_role_list(
  order_by = c("createdOn", "id", "title", "createdBy"),
  sort = c("ASC", "DESC")
)

cto_user_list(
  order_by = c("createdOn", "username", "roleId", "modifiedOn"),
  sort = c("ASC", "DESC"),
  role_id = NULL
)
}
\arguments{
\item{which}{String. Specifies which subset of metadata to return for
\code{cto_metadata()}. One of:
\itemize{
\item \code{"all"} (default): Returns a list containing groups, datasets, and forms.
\item \code{"groups"}: Returns a data frame of form groups.
\item \code{"datasets"}: Returns a data frame of server datasets.
\item \code{"forms"}: Returns a data frame of deployed forms.
}}

\item{order_by}{String. Field to sort the results by. Available fields vary
by function (e.g., \code{"createdOn"}, \code{"id"}, \code{"title"}, or \code{"username"}).}

\item{sort}{String. Sort direction: \code{"ASC"} (ascending) or \code{"DESC"} (descending).}

\item{parent_group_id}{Number (Optional). Filter groups by their parent group ID.}

\item{role_id}{String (Optional). Filter users by a specific Role ID.}
}
\value{
The return value depends on the function:
\itemize{
\item \code{cto_form_ids()} and \code{cto_team_list()} return a \strong{character vector} of IDs.
\item \code{cto_metadata()} returns a \strong{list} (if \code{which = "all"}) or a \strong{data frame}.
\item \code{cto_group_list()}, \code{cto_role_list()}, and \code{cto_user_list()} return a \strong{list}
or \strong{data frame} of the requested resources (depending on pagination handling).
}
}
\description{
These functions retrieve various metadata and lists of resources (forms,
groups, teams, roles, users) from the SurveyCTO server.
\itemize{
\item \code{cto_metadata()}: Retrieves a combined structure of forms, groups, and
datasets (legacy console endpoint).
\item \code{cto_form_ids()}: Returns a simple vector of all form IDs.
\item \code{cto_group_list()}: Lists all form groups.
\item \code{cto_team_list()}: Lists all available team IDs.
\item \code{cto_role_list()}: Lists all defined user roles.
\item \code{cto_user_list()}: Lists all users on the server.
}
}
\examples{
\dontrun{
# --- 1. Basic Metadata ---
# Get all form IDs as a vector
ids <- cto_form_ids()

# Get detailed metadata about forms
meta_forms <- cto_metadata("forms")

# --- 2. Resource Lists ---
# List all groups, sorted by title
groups <- cto_group_list(order_by = "title", sort = "asc")

# List all users with a specific role
admins <- cto_user_list(role_id = "admin_role_id")
}
}
\concept{Server Metadata}
