% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{schmitt2013}
\alias{schmitt2013}
\title{A Lemna effect study data set with multiple treatment levels}
\format{
An object of class \code{data.frame} with 56 rows and 4 columns.
}
\usage{
schmitt2013
}
\description{
Data was collected from Schmitt et al. (2013). The study observed the number of
Lemna fronds during the study period of 14 days. The organisms were exposed
to multiple concentrations of the sulfonyl urea herbicide \emph{metsulfuron-methyl}.
}
\details{
The number of Lemna fronds was recorded at the beginning of the experiment (t=0)
and after 3, 5, 7, 10, 12, and 14 days. The exposure to \emph{metsulfuron-methyl}
was only present during the first seven days, which was followed by a recovery
period of another seven days without exposure to the substance.

The tabular dataset consists of four columns:
\itemize{
\item First column: time (days)
\item Second column: observed number of fronds (-)
\item Third column: trial id (-)
\item Fourth column: metsulfuron-methyl concentration (ug/L)
}

An example \link{scenario} with parameters fitted to the experimental data set
as conducted by Schmitt et al. is available as \code{\link{metsulfuron}}.
}
\references{
Schmitt W., Bruns E., Dollinger M., and Sowig P., 2013: \emph{Mechanistic TK/TD-model
simulating the effect of growth inhibitors on Lemna populations}. Ecol Model 255,
pp. 1-10. \doi{10.1016/j.ecolmodel.2013.01.017}
}
\seealso{
\link{Lemna-models}, \link{metsulfuron}
}
\keyword{datasets}
