% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoenc_base_e.R
\name{autoenc_base_e}
\alias{autoenc_base_e}
\title{Autoencoder base (encoder)}
\usage{
autoenc_base_e(input_size, encoding_size)
}
\arguments{
\item{input_size}{dimensionality of the input vector}

\item{encoding_size}{dimensionality of the latent (encoded) vector}
}
\value{
returns an \code{autoenc_base_e} object
}
\description{
Base class for encoder‑only autoencoders. Intended to be subclassed by
concrete implementations that learn a lower‑dimensional latent representation.
}
\details{
This base does not train or transform by itself (identity). Implementations should
override \code{fit()} to learn parameters and \code{transform()} to output the encoded representation.
}
\examples{
# See an end‑to‑end example at:
# https://github.com/cefet-rj-dal/daltoolbox/blob/main/autoencoder/autoenc_base_e.md

}
\references{
Hinton, G. E., & Salakhutdinov, R. R. (2006). Reducing the Dimensionality of Data with Neural Networks. Science.
}
