% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assigncl.r
\name{assigncl}
\alias{assigncl}
\title{Function to assign classes based upon a variable of interest.}
\usage{
assigncl(
  data = data,
  variable = variable,
  num.class = 4,
  breaks = NULL,
  wclass = NULL,
  mincl = NULL,
  name.class = NULL
)
}
\arguments{
\item{data}{a dataframe having the variable of interest for each
observation.}

\item{variable}{a character giving the column name of the
numeric variable to be used for defining the limits
of each class.}

\item{num.class}{the number of classes to be build. The default
is set to 4. Regardless, the percentiles are used to set
the limits of each class.}

\item{breaks}{is a vector having the numbers to be used
as breakpoints, by default is set to \code{NULL}, therefore the
breakpoints will be determined by the \code{num.class}.}

\item{wclass}{a number defining the width or amplitud of the
classes. By default is set to \code{NULL}, otherwise, the width is
determined by the previous explained options, such as, \code{breaks} or
\code{num.clases}.}

\item{mincl}{the number of the minimum class to be
used. By default is set to \code{NULL}, otherwise, this
option is used to define the breaks.}

\item{name.class}{a character giving the column name of the new
class variable. By default is set to \code{NULL}, then, the column
name will be a composite-name merging the character provided
in \code{variable} followed by ".class". Otherwise, will
be \code{name.class}.}
}
\value{
The main output is the data including a new column having
the created class variable.
}
\description{
Assigns class of each observation in a dataframe
}
\details{
The function assign a class or category to a random
variable of interest. Several alternatives are implemented
to define the way on which the allocation to a respective class
is carried out.
}
\examples{

# The data  
library(datana)
maple
# Example 1
graphics::boxplot(maple$dbh)
df<-assigncl(data=maple,variable="dbh")
head(df)
table(df$dbh.class)
# Example 2, changing the number of classes
df<-assigncl(data=maple,variable="dbh",num.class=5)
table(df$dbh.class)
tapply(df$dbh,df$dbh.class,range)
# Example 3, fixing the breakpoints
df<-assigncl(data=maple,variable="dbh",
             breaks = c(25.60,36.44,40.12,42.3))
table(df$dbh.class)
tapply(df$dbh,df$dbh.class,range)
# Example 4, giving the amplitude
# of the classes
df<-assigncl(data=llancahue,variable="dbh",wclass = 5)
table(df$dbh.class)
tapply(df$dbh,df$dbh.class,range)
}
\references{
\itemize{
\item Salas C. 2002. Ajuste y validación de ecuaciones de volumen para
un relicto del bosque de roble-laurel-lingue.
Bosque 23(2):81–92. \doi{10.4067/S0717-92002002000200009}.
}
}
\author{
Christian Salas-Eljatib and Marcos Marivil.
}
