% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.Date.R
\name{as.Date.haven_labelled_defined}
\alias{as.Date.haven_labelled_defined}
\title{Coerce a defined Date vector to a base R Date}
\usage{
\method{as.Date}{haven_labelled_defined}(x, strip_attributes = FALSE, ...)
}
\arguments{
\item{x}{A vector created with \code{\link[=defined]{defined()}} with underlying type
\code{Date}.}

\item{strip_attributes}{Logical; should the semantic metadata attributes
(label, unit, definition, namespace) be removed from the returned
vector? Defaults to \code{FALSE}.}

\item{...}{Additional arguments passed to \code{\link[base:as.Date]{base::as.Date()}}.}
}
\value{
A \code{Date} vector, optionally carrying semantic metadata.
}
\description{
Coerces a \code{\link{haven_labelled_defined}} vector whose underlying type is
\code{\link{Date}} into a base R \code{Date} vector.

This method preserves the underlying date values and, by default,
also retains any semantic metadata attached to the variable.
}
\details{
Use \code{strip_attributes = TRUE} when flattening or preparing data for
external pipelines, but keep the default when working with defined
vectors directly.

Base R's \code{\link[=as.Date]{as.Date()}} also works, as it dispatches to this method via
S3. However, using \code{as.Date()} on defined vectors is considered safe
because this method ensures metadata is handled predictably.
}
\examples{
d <- defined(Sys.Date() + 0:2, label = "Observation date")

# Recommended usage
as.Date(d)

# Stripping metadata
as.Date(d, strip_attributes = TRUE)

}
\seealso{
\code{\link[=as.POSIXct]{as.POSIXct()}},
\code{\link[=as_numeric]{as_numeric()}}, \code{\link[=as_character]{as_character()}}, \code{\link[=as_logical]{as_logical()}},
\code{\link[=defined]{defined()}}
}
