% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-gdp.R
\docType{data}
\name{gdp}
\alias{gdp}
\title{A Small GDP Dataset}
\format{
A data frame with 10 rows and 5 variables:
\itemize{
\item \code{geo}: Country name (character)
\item \code{year}: Reference year (integer)
\item \code{gdp}: Gross Domestic Product value (numeric)
\item \code{unit}: Unit of measurement, e.g., "Million EUR" (character)
\item \code{freq}: Observation frequency, e.g., "Annual" (character)
}
}
\source{
Eurostat (2021). GDP and main aggregates - international data
cooperation (annual data). \doi{10.2908/NAIDA_10_GDP}
}
\usage{
gdp
}
\description{
A compact sample of GDP and main aggregates from Eurostat's annual
international cooperation dataset. This data subset contains illustrative
records for select countries and time periods.
}
\details{
This dataset is intended for examples, tests, and demonstration purposes. It
reflects simplified GDP data as published by Eurostat. The actual Eurostat
dataset includes more countries, breakdowns, and metadata.
}
\examples{
head(gdp)
}
\keyword{datasets}
