
<!-- README.md is generated from README.Rmd. Please edit that file -->

# {date4ts} <a href="https://tractortom.github.io/date4ts/"><img src="man/figures/logo.svg" align="right" height="150" style="float:right; height:150px;"/></a>

<!-- badges: start -->

[![CRAN
status](https://www.r-pkg.org/badges/version/date4ts)](https://CRAN.R-project.org/package=date4ts)
[![GH Pages
built](https://github.com/TractorTom/date4ts/actions/workflows/pkgdown.yaml/badge.svg)](https://github.com/TractorTom/date4ts/actions/workflows/pkgdown.yaml)
[![R-CMD-check](https://github.com/TractorTom/date4ts/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/TractorTom/date4ts/actions/workflows/R-CMD-check.yaml)

[![lint](https://github.com/TractorTom/date4ts/actions/workflows/lint.yaml/badge.svg)](https://github.com/TractorTom/date4ts/actions/workflows/lint.yaml)
[![Coverage](https://codecov.io/gh/TractorTom/date4ts/graph/badge.svg)](https://app.codecov.io/gh/TractorTom/date4ts)
[![CodeFactor](https://www.codefactor.io/repository/github/TractorTom/date4ts/badge)](https://www.codefactor.io/repository/github/TractorTom/date4ts)
<!-- badges: end -->

date4ts est une boite à outils pour la manipulation des objets `ts` en
R.

La motivation pour la création de ce package est le fait que pour créer
un objet `ts` en R, il faut préciser la date sous le format $AAAA PP$
(avec $AAAA$ l’année en 4 chiffres et $PP$ le numéro de la période).

Par exemple, pour désigner le mois de septembre 2024, on utilise
`c(2024, 9)` et pour désigner le mois de janvier 2025 on peut écrire
`c(2025, 1)` ou `2025`.

Mais on peut aussi utiliser le time-units ($AAAA + PP / f$ avec $f$ la
fréquence).

L’idée est d’uniformiser les dates avec un ensemble de fonction de
conversion, de formattage mais aussi de modification des `ts`.

## Installation

You can install the development version of date4ts from
[GitHub](https://github.com/) with:

``` r
# install.packages("remotes")
remotes::install_github("TractorTom/date4ts")
```

## Usage

``` r
library("date4ts")
```

### Converting Dates

- Convert a date from TimeUnits format to `date_ts` format:

``` r
as_yyyytt(2019.75) # 4th quarter 2019
#> [1] 2019    4
as_yyyytt(2020) # 1st quarter 2020
#> [1] 2020    1
as_yyyytt(2022 + 1 / 4) # 2nd quarter 2022
#> [1] 2022    2
```

- Convert a monthly date to a quarterly date:

``` r
trim2mens(c(2019L, 4L)) # 4th quarter 2019 -> October 2019
#> [1] 2019   10
mens2trim(c(2020L, 11L)) # November 2020 -> 4th quarter 2020
#> [1] 2020    4
```

### Manipulating Dates

- Get the previous date:

``` r
previous_date_ts(c(2020L, 4L), frequency_ts = 4L, lag = 2L)
#> [1] 2020    2
```

- Get the next date:

``` r
next_date_ts(c(2020L, 4L), frequency_ts = 4L, lag = 2L)
#> [1] 2021    2
```

- Find the first non-NA date in a time series:

``` r
ts1 <- ts(c(NA, NA, NA, 1:10, NA), start = 2000, frequency = 12L)
first_date(ts1)
#> [1] 2000    4
```

### Data Retrieval and Modification

- Retrieve values from a time series:

``` r
ts1 <- ts(1:100, start = 2012L, frequency = 12L)
get_value_ts(series = ts1, date_from = c(2015L, 7L), date_to = c(2018L, 6L))
#>  [1] 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67
#> [26] 68 69 70 71 72 73 74 75 76 77 78
```

- Set values in a time series:

``` r
set_value_ts(series = ev_pib, date_ts = c(2021L, 2L), replacement = c(1, 2, 3))
#>               Qtr1          Qtr2          Qtr3          Qtr4
#> 1970            NA            NA            NA            NA
#> 1971            NA            NA            NA            NA
#> 1972            NA            NA            NA            NA
#> 1973            NA            NA            NA            NA
#> 1974            NA            NA            NA            NA
#> 1975            NA            NA            NA            NA
#> 1976            NA            NA            NA            NA
#> 1977            NA            NA            NA            NA
#> 1978            NA            NA            NA            NA
#> 1979            NA            NA            NA            NA
#> 1980            NA  -0.552712174  -0.086754850  -0.130764175
#> 1981   0.436797694   0.663555818   0.655755678   0.465977515
#> 1982   0.892058545   0.662204954   0.047370440   0.507157219
#> 1983   0.581233329  -0.042548981   0.077874681   0.583935348
#> 1984   0.619554314   0.363253711   0.462243113   0.288218891
#> 1985   0.123719710   0.631349292   0.756575266   0.327524429
#> 1986   0.357772133   1.122129272   0.326669036   0.370966439
#> 1987   0.251659155   1.144598588   0.680758053   1.694026185
#> 1988   1.231391234   0.593185145   1.302640709   1.065361026
#> 1989   1.260037978   0.825806743   1.075064005   1.523944130
#> 1990   0.517826385   0.377746880   0.459923112   0.366254003
#> 1991  -0.156699858   0.309591699   0.289346425   0.496079715
#> 1992   0.967856839  -0.057920191   0.028450027  -0.223321860
#> 1993  -0.556650909   0.039547303   0.133452547   0.269728893
#> 1994   0.725093411   1.095551160   0.539244435   0.886607198
#> 1995   0.569503181   0.478767111   0.081524147   0.164939274
#> 1996   0.631394447   0.165893251   0.621382576   0.125750143
#> 1997   0.302664793   1.148738446   0.785645124   1.092788520
#> 1998   0.838700519   0.933602781   0.685747514   0.764421531
#> 1999   0.504428016   0.825984551   1.222733930   1.401265205
#> 2000   0.909693692   0.987402187   0.624501289   0.812645817
#> 2001   0.547797973   0.184046964   0.272336544   0.026816438
#> 2002   0.372541324   0.461330701   0.418587141  -0.054011578
#> 2003   0.203235664  -0.218262571   0.676991816   0.717703853
#> 2004   0.939180093   0.645697044   0.258638250   0.744155119
#> 2005   0.269714193   0.198490900   0.500009124   0.776948575
#> 2006   0.754542470   1.015941519   0.013572258   0.786297420
#> 2007   0.740940215   0.773456477   0.351755993   0.225637214
#> 2008   0.395791727  -0.412315400  -0.280602493  -1.467532567
#> 2009  -1.632375943  -0.101454578   0.160750061   0.695136221
#> 2010   0.368232308   0.507493101   0.645610703   0.704301595
#> 2011   0.997901680   0.027941934   0.367134262   0.173618343
#> 2012   0.093557392  -0.157293866   0.191962538  -0.077204189
#> 2013  -0.001133455   0.655711072   0.012011561   0.475525630
#> 2014   0.084980333   0.118498226   0.504372721   0.081229345
#> 2015   0.489945372   0.007744848   0.332080732   0.139118865
#> 2016   0.636268205  -0.161024723   0.198728721   0.544690904
#> 2017   0.816780164   0.820053915   0.622880698   0.828202860
#> 2018   0.048700300   0.382559370   0.366396552   0.701164421
#> 2019   0.665798334   0.604099134   0.011971808  -0.400152537
#> 2020  -5.647477753 -13.443145590  18.555378962  -1.118046566
#> 2021   0.156198162   1.000000000   2.000000000   3.000000000
#> 2022  -0.047254400            NA            NA
```

- Combine two time series:

``` r
trim_1 <- stats::ts(rep(1, 4), start = 2021, frequency = 4L)
combine2ts(ev_pib, trim_1)
#>               Qtr1          Qtr2          Qtr3          Qtr4
#> 1970            NA            NA            NA            NA
#> 1971            NA            NA            NA            NA
#> 1972            NA            NA            NA            NA
#> 1973            NA            NA            NA            NA
#> 1974            NA            NA            NA            NA
#> 1975            NA            NA            NA            NA
#> 1976            NA            NA            NA            NA
#> 1977            NA            NA            NA            NA
#> 1978            NA            NA            NA            NA
#> 1979            NA            NA            NA            NA
#> 1980            NA  -0.552712174  -0.086754850  -0.130764175
#> 1981   0.436797694   0.663555818   0.655755678   0.465977515
#> 1982   0.892058545   0.662204954   0.047370440   0.507157219
#> 1983   0.581233329  -0.042548981   0.077874681   0.583935348
#> 1984   0.619554314   0.363253711   0.462243113   0.288218891
#> 1985   0.123719710   0.631349292   0.756575266   0.327524429
#> 1986   0.357772133   1.122129272   0.326669036   0.370966439
#> 1987   0.251659155   1.144598588   0.680758053   1.694026185
#> 1988   1.231391234   0.593185145   1.302640709   1.065361026
#> 1989   1.260037978   0.825806743   1.075064005   1.523944130
#> 1990   0.517826385   0.377746880   0.459923112   0.366254003
#> 1991  -0.156699858   0.309591699   0.289346425   0.496079715
#> 1992   0.967856839  -0.057920191   0.028450027  -0.223321860
#> 1993  -0.556650909   0.039547303   0.133452547   0.269728893
#> 1994   0.725093411   1.095551160   0.539244435   0.886607198
#> 1995   0.569503181   0.478767111   0.081524147   0.164939274
#> 1996   0.631394447   0.165893251   0.621382576   0.125750143
#> 1997   0.302664793   1.148738446   0.785645124   1.092788520
#> 1998   0.838700519   0.933602781   0.685747514   0.764421531
#> 1999   0.504428016   0.825984551   1.222733930   1.401265205
#> 2000   0.909693692   0.987402187   0.624501289   0.812645817
#> 2001   0.547797973   0.184046964   0.272336544   0.026816438
#> 2002   0.372541324   0.461330701   0.418587141  -0.054011578
#> 2003   0.203235664  -0.218262571   0.676991816   0.717703853
#> 2004   0.939180093   0.645697044   0.258638250   0.744155119
#> 2005   0.269714193   0.198490900   0.500009124   0.776948575
#> 2006   0.754542470   1.015941519   0.013572258   0.786297420
#> 2007   0.740940215   0.773456477   0.351755993   0.225637214
#> 2008   0.395791727  -0.412315400  -0.280602493  -1.467532567
#> 2009  -1.632375943  -0.101454578   0.160750061   0.695136221
#> 2010   0.368232308   0.507493101   0.645610703   0.704301595
#> 2011   0.997901680   0.027941934   0.367134262   0.173618343
#> 2012   0.093557392  -0.157293866   0.191962538  -0.077204189
#> 2013  -0.001133455   0.655711072   0.012011561   0.475525630
#> 2014   0.084980333   0.118498226   0.504372721   0.081229345
#> 2015   0.489945372   0.007744848   0.332080732   0.139118865
#> 2016   0.636268205  -0.161024723   0.198728721   0.544690904
#> 2017   0.816780164   0.820053915   0.622880698   0.828202860
#> 2018   0.048700300   0.382559370   0.366396552   0.701164421
#> 2019   0.665798334   0.604099134   0.011971808  -0.400152537
#> 2020  -5.647477753 -13.443145590  18.555378962  -1.118046566
#> 2021   1.000000000   1.000000000   1.000000000   1.000000000
#> 2022  -0.047254400            NA            NA
```

- Extend a time series with new values:

``` r
ts1 <- ts(data = c(rep(NA_integer_, 3L), 1L:10L, rep(NA_integer_, 3L)), start = 2020, frequency = 12L)
x <- rep(3L, 2L)
extend_ts(series = ts1, replacement = x)
#> Warning: extending time series when replacing values
#>      Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec
#> 2020  NA  NA  NA   1   2   3   4   5   6   7   8   9
#> 2021  10   3   3
```

### Formatting and Labels

- Normalize a date:

``` r
normalize_date_ts(c(2020L, 0L), frequency_ts = 4L) # 4th quarter of 2019
#> Warning in assert_date_ts(x = date_ts, frequency_ts, add = coll, .var.name =
#> "date_ts"): Assertion on 'period' failed: Element 1 is not >= 1.
#> [1] 2019    4
normalize_date_ts(c(2020L, 0L), frequency_ts = 4L, test = FALSE) # 4th quarter of 2019
#> [1] 2019    4
```

- Generate labels for a period:

``` r
libelles(date_ts = c(2019L, 10L), frequency_ts = 12L, n = 9L)
#> [1] "Oct 2019" "Nov 2019" "Dec 2019" "Jan 2020" "Feb 2020" "Mar 2020" "Apr 2020"
#> [8] "May 2020" "Jun 2020"
```

### Data Information

- Evolution of French GDP until Q1 2022:

``` r
ev_pib
#>               Qtr1          Qtr2          Qtr3          Qtr4
#> 1970            NA            NA            NA            NA
#> 1971            NA            NA            NA            NA
#> 1972            NA            NA            NA            NA
#> 1973            NA            NA            NA            NA
#> 1974            NA            NA            NA            NA
#> 1975            NA            NA            NA            NA
#> 1976            NA            NA            NA            NA
#> 1977            NA            NA            NA            NA
#> 1978            NA            NA            NA            NA
#> 1979            NA            NA            NA            NA
#> 1980            NA  -0.552712174  -0.086754850  -0.130764175
#> 1981   0.436797694   0.663555818   0.655755678   0.465977515
#> 1982   0.892058545   0.662204954   0.047370440   0.507157219
#> 1983   0.581233329  -0.042548981   0.077874681   0.583935348
#> 1984   0.619554314   0.363253711   0.462243113   0.288218891
#> 1985   0.123719710   0.631349292   0.756575266   0.327524429
#> 1986   0.357772133   1.122129272   0.326669036   0.370966439
#> 1987   0.251659155   1.144598588   0.680758053   1.694026185
#> 1988   1.231391234   0.593185145   1.302640709   1.065361026
#> 1989   1.260037978   0.825806743   1.075064005   1.523944130
#> 1990   0.517826385   0.377746880   0.459923112   0.366254003
#> 1991  -0.156699858   0.309591699   0.289346425   0.496079715
#> 1992   0.967856839  -0.057920191   0.028450027  -0.223321860
#> 1993  -0.556650909   0.039547303   0.133452547   0.269728893
#> 1994   0.725093411   1.095551160   0.539244435   0.886607198
#> 1995   0.569503181   0.478767111   0.081524147   0.164939274
#> 1996   0.631394447   0.165893251   0.621382576   0.125750143
#> 1997   0.302664793   1.148738446   0.785645124   1.092788520
#> 1998   0.838700519   0.933602781   0.685747514   0.764421531
#> 1999   0.504428016   0.825984551   1.222733930   1.401265205
#> 2000   0.909693692   0.987402187   0.624501289   0.812645817
#> 2001   0.547797973   0.184046964   0.272336544   0.026816438
#> 2002   0.372541324   0.461330701   0.418587141  -0.054011578
#> 2003   0.203235664  -0.218262571   0.676991816   0.717703853
#> 2004   0.939180093   0.645697044   0.258638250   0.744155119
#> 2005   0.269714193   0.198490900   0.500009124   0.776948575
#> 2006   0.754542470   1.015941519   0.013572258   0.786297420
#> 2007   0.740940215   0.773456477   0.351755993   0.225637214
#> 2008   0.395791727  -0.412315400  -0.280602493  -1.467532567
#> 2009  -1.632375943  -0.101454578   0.160750061   0.695136221
#> 2010   0.368232308   0.507493101   0.645610703   0.704301595
#> 2011   0.997901680   0.027941934   0.367134262   0.173618343
#> 2012   0.093557392  -0.157293866   0.191962538  -0.077204189
#> 2013  -0.001133455   0.655711072   0.012011561   0.475525630
#> 2014   0.084980333   0.118498226   0.504372721   0.081229345
#> 2015   0.489945372   0.007744848   0.332080732   0.139118865
#> 2016   0.636268205  -0.161024723   0.198728721   0.544690904
#> 2017   0.816780164   0.820053915   0.622880698   0.828202860
#> 2018   0.048700300   0.382559370   0.366396552   0.701164421
#> 2019   0.665798334   0.604099134   0.011971808  -0.400152537
#> 2020  -5.647477753 -13.443145590  18.555378962  -1.118046566
#> 2021   0.156198162   1.460529708   3.017719839   0.779781860
#> 2022  -0.047254400            NA            NA
```
