% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/defm-package.R
\name{defm_terms}
\alias{defm_terms}
\alias{td_ones}
\alias{terms_defm}
\alias{td_generic}
\alias{td_formula}
\alias{td_logit_intercept}
\alias{rule_not_one_to_zero}
\alias{rule_constrain_support}
\alias{+.DEFM}
\title{Model specification for DEFM}
\usage{
td_ones(m, covar = "")

td_generic(m, mat, covar = "")

td_formula(m, formula, new_name = "")

td_logit_intercept(m, y_indices = as.integer(c()), covar = "")

rule_not_one_to_zero(m, term_indices)

rule_constrain_support(m, term_index, lb, ub)

\method{+}{DEFM}(e1, e2)
}
\arguments{
\item{m}{An object of class \link{DEFM}.}

\item{covar}{String. Name of a covariate to use as an interaction
for the effect. If equal to \code{""}, then no interaction effect.
is used.
used to weight the term.}

\item{mat}{Integer matrix. The matrix specifies the type of motif to capture
(see details.)}

\item{formula}{Character scalar (see details).}

\item{new_name}{Character scalar. Name to be assigned for the new term.
if empty, then it builds a name based on the formula.}

\item{y_indices}{Integer vector with the coordinates to include in the term.}

\item{term_indices}{Non-negative vector of indices. Indicates which
outcomes this rule will apply.}

\item{term_index}{Non-negative scalar. Which term this rule will apply.}

\item{lb, ub}{Numeric scalars. Lower and upper bounds.}

\item{e1, e2}{e1 An object of class \link{DEFM} (e1) and a character (e2).}
}
\value{
Invisible 0.
}
\description{
Model specification for DEFM
}
\details{
In \code{td_generic}, users can specify a particular motif to model. Motifs
are represented by cells with values equal to 1, for example, the matrix:

\if{html}{\out{<div class="sourceCode y0 y1 y2">}}\preformatted{t0:   1 NA NA
t1:   1  1 NA
}\if{html}{\out{</div>}}

represents a transition \verb{y0 -> (y1, y2)}. If 0 is a motif of interest, then
the matrix should include 0 to mark zero values.

The function \code{td_formula},
will take the formula and generate the corresponding
input for defm::counter_transition(). Formulas can be specified in the
following ways:
\itemize{
\item Intercept effect: \code{{...}} No transition, only including the current state.
\item Transition effect: \code{{...} > {...}} Includes current and previous states.
}

The general notation is \verb{[0]y[column id]_[row id]}. A preceeding zero
means that the value of the cell is considered to be zero. The column
id goes between 0 and the number of columns in the array - 1 (so it
is indexed from 0,) and the row id goes from 0 to m_order.

Both Intercepts and Transition can interact with covariates. Using
either the \code{covar} argument or, in the case of formulas, \verb{x [Covar name]},
for example:
\itemize{
\item Intercept effect: \verb{\{...\} x Hispanic} interacts with the Hispanic covar.
\item Transition effect: \verb{\{...\} > \{...\} x Hispanic} Same.
}
\subsection{Intercept effects}{

Intercept effects only involve a single set of curly brackets. Using the
'greater-than' symbol (i.e., \code{<}) is only for transition effects. When
specifying intercept effects, users can skip the \code{row_id}, e.g.,
\code{y0_0} is equivalent to \code{y0}. If the passed \verb{row id} is different from
the Markov order, i.e., \code{row_id != m_order}, then the function returns
with an error.

Examples:
\itemize{
\item \code{"{y0, 0y1}"} is equivalent to set a motif with the first element equal
to one and the second to zero.
}
}

\subsection{Transition effects}{

Transition effects can be specified using two sets of curly brackets and
an greater-than symbol, i.e., \code{{...} > {...}}. The first set of brackets,
which we call LHS, can only hold \verb{row id} that are less than \code{m_order}.
}

The term \code{td_logit_intercept} will add what is equivalent to an
intercept in a logistic regression. When \code{y_indices} is specified, then the
function will add one intercept per outcome. These can be weighted by
a covariate.

The function \code{rule_not_one_to_zero} will avoid the transition one to zero in a Markov process.

The function \code{rule_constrain_support} will constrain the support of the model
by specifying a lower and upper bound for a given statistic.

The \code{+} method is a shortcut for term_formula
}
\examples{
# Loading Valtente's SNS data
data(valentesnsList)

mymodel <- new_defm(
  id    = valentesnsList$id,
  Y     = valentesnsList$Y,
  X     = valentesnsList$X,
  order = 1
)

# Conventional regression intercept
td_logit_intercept(mymodel)

# Interaction effect with Hispanic
td_logit_intercept(mymodel, covar = "Hispanic")

# Transition effect from only y1 to both equal to 1.
td_formula(mymodel, "{y1, 0y2} > {y1, y2}")

# Same but interaction with Female
td_formula(mymodel, "{y1, 0y2} > {y1, y2} x Female")

# Inspecting the model
mymodel

# Initializing and fitting
init_defm(mymodel)
defm_mle(mymodel)
}
