% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_stats}
\alias{get_stats}
\title{Get sufficient statistics counts}
\usage{
get_stats(m)
}
\arguments{
\item{m}{An object of class \link{DEFM}.}
}
\value{
A matrix with the counts of the sufficient statistics.
}
\description{
This function computes the individual counts of the sufficient statistics
included in the model.
}
\examples{
data(valentesnsList)

mymodel <- new_defm(
  id = valentesnsList$id,
  Y = valentesnsList$Y,
  X = valentesnsList$X,
  order = 1
)

# Adding the intercept terms and a motif from tobacco to mj
td_logit_intercept(mymodel)
td_formula(mymodel, "{y1, 0y2} > {y1, y2}")

# Initialize the model
init_defm(mymodel)

# Get the counts
head(get_stats(mymodel))
}
