#' Measured precipitation from a rainfall event
#'
#' A dataset containing measured precipitation data from the Minneapolis St. Paul Area:
#'
#' \itemize{
#'   \item date. Calendar day of year of measurement
#'   \item time. Time measurement is made
#'   \item station_id Shorthand name for station in CoCoRaHS network
#'   \item station_name Name of station in CoCoRaHS network
#'   \item precip. Observed precipitation (inches)
#' }
#'
#' @docType data
#' @keywords datasets
#' @name precipitation
#' @usage data(precipitation)
#' @format A data frame with 56 rows and 5 variables
#' @source The data were collected from Community Collaborative Rain Hail and Snow Network (CoCoRaHS). \url{https://www.cocorahs.org/ViewData/ListDailyPrecipReports.aspx}
NULL
