% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum_crosstab.R
\name{sum_crosstab}
\alias{sum_crosstab}
\title{Crosstabulation with Counts and Percentages}
\usage{
sum_crosstab(
  data,
  row_var,
  col_var,
  percent = c("none", "cell", "row", "col"),
  digits = 2
)
}
\arguments{
\item{data}{A data frame containing the variables to be cross-tabulated.}

\item{row_var}{A character string specifying the row variable (categorical).}

\item{col_var}{A character string specifying the column variable (categorical).}

\item{percent}{Type of percentage to display alongside counts. One of
\code{"none"} (counts only), \code{"cell"} (percentage of total),
\code{"row"} (row percentage), or \code{"col"} (column percentage).}

\item{digits}{Integer specifying the number of decimal places for percentages.}
}
\value{
A \code{flextable} object containing the formatted cross-tabulation
with counts, optional percentages, and marginal totals.
}
\description{
Creates a cross-tabulation (contingency table) between two categorical variables
and returns a publication-ready table as a \code{flextable}. The table displays
cell counts with optional percentages (cell-wise, row-wise, or column-wise),
and includes row totals (right) and column totals (bottom).
}
\examples{
data(CO2)

sum_crosstab(
  data = CO2,
  row_var = "Treatment",
  col_var = "Type",
  percent = "cell",
  digits = 2
)
}
