% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.dim.R
\name{ds.dim}
\alias{ds.dim}
\title{Retrieves the dimension of a server-side R object}
\usage{
ds.dim(x = NULL, type = "both", checks = FALSE, datasources = NULL)
}
\arguments{
\item{x}{a character string providing the name of the input object.}

\item{type}{a character string that represents the type of analysis to carry out. 
If \code{type} is set to \code{'combine'}, \code{'combined'}, \code{'combines'} or \code{'c'},
 the global dimension is returned. 
If \code{type} is set to \code{'split'}, \code{'splits'} or \code{'s'}, 
the dimension is returned separately for each study.
If \code{type} is set to \code{'both'} or \code{'b'}, both sets of outputs are produced.
Default \code{'both'}.}

\item{checks}{logical. If TRUE undertakes all DataSHIELD checks (time-consuming).
Default FALSE.}

\item{datasources}{a list of \code{\link[DSI]{DSConnection-class}} 
objects obtained after login. If the \code{datasources} argument is not specified
the default set of connections will be used: see \code{\link[DSI]{datashield.connections_default}}.}
}
\value{
\code{ds.dim} retrieves to the client-side the dimension of the object 
in the form of a vector where the first
element indicates the number of rows and the second element indicates the number of columns.
}
\description{
Gives the dimensions of an R object on the server-side. 
This function is similar to R function \code{dim}.
}
\details{
The function returns the dimension of the server-side 
input object (e.g. array, matrix or data frame)
from every single study and the pooled dimension of the object by summing up the individual 
dimensions returned from each study.

In \code{checks} parameter is suggested that checks should only be undertaken once the 
function call has failed.

Server function called: \code{dimDS}
}
\examples{
\dontrun{

  ## Version 6, for version 5 see the Wiki
  
  # connecting to the Opal servers

  require('DSI')
  require('DSOpal')
  require('dsBaseClient')

  builder <- DSI::newDSLoginBuilder()
  builder$append(server = "study1", 
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM1", driver = "OpalDriver")
  builder$append(server = "study2", 
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM2", driver = "OpalDriver")
  builder$append(server = "study3",
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM3", driver = "OpalDriver")
  logindata <- builder$build()
  
  connections <- DSI::datashield.login(logins = logindata, assign = TRUE, symbol = "D") 
  

  # Calculate the dimension
  ds.dim(x="D", 
         type="combine", #global dimension
         checks = FALSE,
         datasources = connections)#all opal servers are used
  ds.dim(x="D",
         type = "both",#separate dimension for each study
                       #and the pooled dimension (default) 
         checks = FALSE,
         datasources = connections)#all opal servers are used
  ds.dim(x="D", 
         type="split", #separate dimension for each study
         checks = FALSE,
         datasources = connections[1])#only the first opal server is used ("study1")

  # clear the Datashield R sessions and logout
  datashield.logout(connections)

}

}
\seealso{
\code{\link{ds.dataFrame}} to generate a table of the type data frame.

\code{\link{ds.changeRefGroup}} to change the reference level of a factor.

\code{\link{ds.colnames}} to obtain the column names of a matrix or a data frame

\code{\link{ds.asMatrix}} to coerce an object into a matrix type.

\code{\link{ds.length}} to obtain the size of a vector.
}
\author{
DataSHIELD Development Team
}
