% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.distinct.R
\name{ds.distinct}
\alias{ds.distinct}
\title{Keep distinct/unique rows}
\usage{
ds.distinct(
  df.name = NULL,
  tidy_expr = NULL,
  .keep_all = FALSE,
  newobj = NULL,
  datasources = NULL
)
}
\arguments{
\item{df.name}{Character specifying a serverside data frame or tibble.}

\item{tidy_expr}{Optionally, list of variables to use when determining uniqueness. If there are multiple rows
for a given combination of inputs, only the first row will be preserved. If omitted, will use all
variables in the data frame.}

\item{.keep_all}{If TRUE, keep all variables in .data. If a combination of \code{expr} is not
distinct, this keeps the first row of values.}

\item{newobj}{Character specifying name for new server-side data frame.}

\item{datasources}{DataSHIELD connections object.}
}
\value{
No return value, called for its side effects. An object (typically a data frame or tibble)
with the name specified by \code{newobj} is created on the server.
}
\description{
DataSHIELD implentation of \code{dplyr::distinct}.
}
\examples{
\dontrun{
ds.distinct(
  df.name = "mtcars",
  expr = list(mpg, cyl),
  newobj = "distinct_df"
)
}
}
