% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.fcm}
\alias{coef.fcm}
\title{Extract Model Coefficients}
\usage{
\method{coef}{fcm}(object, ..., method = c("default", "hessian", "boot"), ci = 0.95)
}
\arguments{
\item{object}{An object of class \code{"fcm"}, typically the result of \code{\link[=fcm]{fcm()}}.}

\item{...}{Further arguments passed to or from other methods.}

\item{method}{Character string specifying the method used to compute confidence intervals.
One of \code{"default"} (point estimate only), \code{"hessian"} (Delta method on log-scale),
or \code{"boot"} (percentile bootstrap).}

\item{ci}{Confidence level for the interval estimation (e.g., 0.95). If \code{NULL},
no confidence interval is returned.}
}
\value{
If \code{method = "default"}, returns a named vector of parameter estimates.
If \code{method = "hessian"} or \code{method = "boot"}, returns a \code{data.frame} with columns:
\itemize{
\item \code{par}: the estimated parameter
\item \code{lower}: lower bound of the CI
\item \code{upper}: upper bound of the CI
}
}
\description{
Extract estimated model parameters from objects returned by \code{\link[=fcm]{fcm()}}.
Optionally computes confidence intervals via either the observed Hessian
(Delta method, on the log scale) or bootstrap sampling.
}
\details{
If \code{method = "hessian"}, confidence intervals are constructed on the log scale
using the Delta method, then exponentiated to return to the original parameter scale.
If \code{method = "boot"}, confidence intervals are computed as empirical quantiles of
the bootstrap replicates.
}
\examples{
\donttest{
data(fit)
coef(fit)
coef(fit, method = "hessian", ci = 0.95)
coef(fit, method = "boot", ci = 0.95)
}

}
\seealso{
\code{\link[=fcm]{fcm()}}
}
