% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cv_recovery.R
\name{plot_cv_recovery}
\alias{plot_cv_recovery}
\alias{plot_cv_recovery.cv4abc}
\title{Plot CV parameter recovery}
\usage{
plot_cv_recovery(data, ...)

\method{plot_cv_recovery}{cv4abc}(data, ...)
}
\arguments{
\item{data}{A \code{cv4abc} object containing true parameters and
cross-validated estimates.}

\item{...}{Additional arguments:
\describe{
  \item{n_rows}{Integer; number of rows in the plot grid (default: 3)}
  \item{n_cols}{Integer; number of columns in the plot grid, multiplied by 2
    for paired plots (default: 1)}
  \item{method}{Character; smoothing method for \code{geom_smooth} (default: "lm")}
  \item{formula}{Formula; used in \code{geom_smooth} (default: y ~ x)}
  \item{resid_tol}{Numeric; quantile threshold for filtering residuals by
    absolute value. If specified, only observations with residuals below
    this quantile are plotted (default: NULL, no filtering)}
  \item{interactive}{Logical; whether to pause between pages and wait for
    user input (default: FALSE)}
}}
}
\value{
Invisibly returns `NULL`. Called for its side effect of producing plots.
}
\description{
Visualize parameter recovery from cross-validation results, showing estimated
vs. true parameter values and residual distributions for each parameter.
}
\examples{
# Load CV output from saved file
cv_file <- system.file(
  "extdata", "rdm_minimal", "abc", "cv", "neuralnet.rds",
  package = "eam"
)
abc_neuralnet_cv <- readRDS(cv_file)

# Plot parameter recovery
plot_cv_recovery(
  abc_neuralnet_cv,
  n_rows = 2,
  n_cols = 1,
  resid_tol = 0.99
)

}
\seealso{
\code{\link{plot_cv_recovery.cv4abc}}
}
