% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugins.R
\name{e_barRange}
\alias{e_barRange}
\title{Bar range chart}
\usage{
e_barRange(
  e,
  lower,
  upper,
  name = "barRange",
  legend = TRUE,
  y_index = 0,
  x_index = 0,
  barWidth = 10,
  borderRadius = 5,
  margin = 10,
  textSymbol = "F",
  ...
)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{lower, upper}{series of lower and upper borders of the band}

\item{name}{name of the serie.}

\item{legend}{Whether to add serie to legend.}

\item{x_index, y_index}{Indexes of x and y axis.}

\item{barWidth}{width of each bar}

\item{borderRadius}{roundness of the bar ends}

\item{margin}{space between the text labels and the bar}

\item{textSymbol}{string for the label to end with}

\item{...}{additional options}
}
\description{
Draw a bar range plot with labels on each end.
}
\examples{
df <- iris |>
  dplyr::group_by(Species) |>
  dplyr::summarise(min_length = min(Sepal.Length),
                   max_length = max(Sepal.Length))

df |> e_chart(Species) |>
  e_barRange(lower = min_length,
             upper = max_length,
             textSymbol = '"'
  )
}
\seealso{
\href{https://github.com/apache/echarts-custom-series/tree/main/custom-series/barRange}{official documentation}
}
