% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugins.R
\name{e_stage}
\alias{e_stage}
\title{Stage chart}
\usage{
e_stage(
  e,
  start,
  end,
  stage,
  legend = TRUE,
  name = "stage",
  borderRadius = 8,
  verticalMargin = 10,
  minHorizontalSize = 3,
  envelope = list(show = TRUE, color = "#888", opacity = 0.25, externalRadius = 8),
  axisLabel = list(formatter = NULL, color = "#8A8A8A"),
  ...
)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{start}{column for start of stage on x axis}

\item{end}{column for end of stage on x axis}

\item{stage}{column for stage on y axis}

\item{legend}{Whether to add serie to legend.}

\item{name}{name of the serie.}

\item{borderRadius}{The border radius of the stage.}

\item{verticalMargin}{The vertical margin of the bars.}

\item{minHorizontalSize}{The minimum width of the bars.}

\item{envelope}{The envelope of the stage.}

\item{axisLabel}{The style of the axis label.}

\item{...}{additional options}
}
\description{
Draw a stage plot.
}
\examples{

df <- data.frame(
  start = as.POSIXct(c(
    "2024-09-07 06:12", "2024-09-07 06:15", "2024-09-07 05:45",
    "2024-09-07 04:57", "2024-09-07 06:12", "2024-09-07 06:18"
  )),

  end = as.POSIXct(c(
    "2024-09-07 06:12", "2024-09-07 06:18", "2024-09-07 06:12",
    "2024-09-07 05:45", "2024-09-07 06:15", "2024-09-07 07:37"
  )),

  stage = c(
    "Awake", "Awake",  "REM",
    "Core", "Core", "Deep"
  ),
  stringsAsFactors = FALSE
 )
stage_order = c( "Deep", "Core","REM", "Awake")

df |>
  e_charts() |>
  e_stage(start = start,
          end = end,
          stage = stage) |>
          e_x_axis(type = 'time') |>
          e_y_axis(type = 'category', data = stage_order)

}
\seealso{
\href{https://github.com/apache/echarts-custom-series/tree/main/custom-series/stage}{official documentation}
}
