% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_dissimilarity_from_cocktail_list}
\alias{get_dissimilarity_from_cocktail_list}
\title{Recover the square matrix of distance between cocktails where the index (i,j)
of the matrix is the distance between cocktails i and j in an arbitrary
cocktail list}
\usage{
get_dissimilarity_from_cocktail_list(cocktails, ATCtree, normalization = TRUE)
}
\arguments{
\item{cocktails}{: A list of cocktails in the form of a vector of integer}

\item{ATCtree}{: ATC tree with upper bound of the DFS (without the root)}

\item{normalization}{: Do we keep the distance between cocktail in the range [0;1] ?}
}
\value{
The square matrix of distances between cocktails
}
\description{
Recover the square matrix of distance between cocktails where the index (i,j)
of the matrix is the distance between cocktails i and j in an arbitrary
cocktail list
}
\examples{
\donttest{
data("ATC_Tree_UpperBound_2024")

cocktails = list(c(561, 904),
               c(1902, 4585)) # only size 2 cocktails allowed for this function

distance_matrix = get_dissimilarity_from_cocktail_list(cocktails = cocktails,
                              ATCtree = ATC_Tree_UpperBound_2024, 
                              normalization = TRUE)
}
}
