% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.emm.R
\name{plot.emmGrid}
\alias{plot.emmGrid}
\alias{plot.summary_emm}
\title{Plot an \code{emmGrid} or \code{summary_emm} object}
\usage{
\method{plot}{emmGrid}(x, y, type, CIs = TRUE, PIs = FALSE,
  comparisons = FALSE, colors, alpha = 0.05, adjust = "tukey",
  int.adjust = "none", intervals, ...)

\method{plot}{summary_emm}(x, y, horizontal = TRUE, CIs = TRUE, xlab, ylab,
  facetlab = "label_both", layout, scale = NULL, colors, intervals,
  plotit = TRUE, ...)
}
\arguments{
\item{x}{Object of class \code{emmGrid} or \code{summary_emm}}

\item{y}{(Required but ignored)}

\item{type}{Character value specifying the type of prediction desired
(matching \code{"linear.predictor"}, \code{"link"}, or \code{"response"}).
See details under \code{\link{summary.emmGrid}}.
In addition, the user may specify \code{type = "scale"}, in which case
a transformed scale (e.g., a log scale) is displayed based on the transformation
or link function used. Additional customization of this scale is available through
including arguments to \code{ggplot2::scale_x_continuous} in \code{...} .}

\item{CIs}{Logical value. If \code{TRUE}, confidence intervals are
plotted for each estimate.}

\item{PIs}{Logical value. If \code{TRUE}, prediction intervals are
plotted for each estimate. If \code{object} is a Bayesian model,
this requires the \code{...} arguments to include
\code{frequentist = TRUE} and \code{sigma =} (some value).
Note that the \code{PIs} option is \emph{not} available with
\code{summary_emm} objects -- only for \code{emmGrid} objects.
Also, prediction intervals are not available
with \code{engine = "lattice"}.}

\item{comparisons}{Logical value. If \code{TRUE}, \dQuote{comparison arrows}
are added to the plot, in such a way that the degree to which arrows
overlap reflects as much as possible the significance of the comparison of
the two estimates. (A warning is issued if this can't be done.)
Note that comparison arrows are not available with `summary_emm` objects.}

\item{colors}{Optional character vector of colors to use for estimates, CIs, PIs, 
and comparison arrows, respectively. If missing, these are derived from
\code{ink}, \code{paper}, and \code{accent} in the theme's \code{geom} element.
\code{ink} is used for the estimates, \code{accent} is used for comparison arrows,
and a contrasting color to \code{accent} is blended with \code{paper} for
the intervals. 
If just one color is given, estimates and intervals are made from
various blends of that color and \code{paper}, and \code{accent}
color is used for comparison arrows.}

\item{alpha}{The significance level to use in constructing comparison arrows}

\item{adjust}{Character value: Multiplicity adjustment method for comparison arrows \emph{only}.}

\item{int.adjust}{Character value: Multiplicity adjustment method for the plotted confidence intervals \emph{only}.}

\item{intervals}{If specified, it is used to set \code{CIs}. This is the previous
argument name for \code{CIs} and is provided for backward compatibility.}

\item{...}{Additional arguments passed to \code{\link{update.emmGrid}}, 
\code{\link{summary.emmGrid}},
\code{\link{predict.emmGrid}}, or
\code{\link[lattice:xyplot]{dotplot}}}

\item{horizontal}{Logical value specifying whether the intervals should be
plotted horizontally or vertically}

\item{xlab}{Character label for horizontal axis}

\item{ylab}{Character label for vertical axis}

\item{facetlab}{Character or function method used to label facets in a 
multi-panel plot (with the \code{ggplot} engine).
Default is \code{"label_both"}, meaning that both factor names and levels are shown,
You can use \code{"label_value"} to save space, or \code{"label_context"}
to decide automatically (often wrongly). See the help page for 
\code{ggplot2::labellers}}

\item{layout}{Numeric value passed to \code{\link[lattice:xyplot]{dotplot}}
when \code{engine == "lattice"}.}

\item{scale}{Object of class \code{trans} (in the \pkg{scales} package) to
specify a nonlinear scale. This is used in lieu of \code{type = "scale"} when
plotting a \code{summary_emm} object created with \code{type = "response"}.
This is ignored with other types of summaries.}

\item{plotit}{Logical value. If \code{TRUE}, a graphical object is returned;
if \code{FALSE}, a data.frame is returned containing all the values
used to construct the plot.}
}
\value{
If \code{plotit = TRUE}, a graphical object is returned.

  If \code{plotit = FALSE}, a \code{data.frame} with the table of
  EMMs that would be plotted. In the latter case, the estimate being plotted
  is named \code{the.emmean}, and any factors involved have the same names as
  in the object. Confidence limits are named \code{lower.CL} and
  \code{upper.CL}, prediction limits are named \code{lpl} and \code{upl}, and
  comparison-arrow limits are named \code{lcmpl} and \code{ucmpl}.
  There is also a variable named \code{pri.fac} which contains the factor 
  combinations that are \emph{not} among the \code{by} variables.
}
\description{
Methods are provided to plot EMMs as side-by-side CIs, and optionally to display 
  \dQuote{comparison arrows} for displaying pairwise comparisons.
}
\note{
In order to play nice with the plotting functions,
any variable names that are not syntactically correct (e.g., contain spaces)
are altered using \code{\link{make.names}}.
}
\section{Details}{

If any \code{by} variables are in force, the plot is divided into separate
panels. For
\code{"summary_emm"} objects, the \code{\dots} arguments in \code{plot}
are passed \emph{only} to \code{dotplot}, whereas for \code{"emmGrid"}
objects, the object is updated using \code{\dots} before summarizing and
plotting.

In plots with \code{comparisons = TRUE}, the resulting arrows are only
approximate, and in some cases may fail to accurately reflect the pairwise
comparisons of the estimates -- especially when estimates having large and
small standard errors are intermingled in just the wrong way. Note that the
maximum and minimum estimates have arrows only in one direction, since there
is no need to compare them with anything higher or lower, respectively. See
the \href{../doc/xplanations.html#arrows}{\code{vignette("xplanations",
"emmeans")}} for details on how these are derived.

If \code{adjust} or \code{int.adjust} are not supplied, they default to the 
internal \code{adjust} setting saved in \code{pairs(x)} and \code{x} 
respectively (see \code{\link{update.emmGrid}}).
}

\examples{
warp.lm <- lm(breaks ~ wool * tension, data = warpbreaks)
warp.emm <- emmeans(warp.lm, ~ tension | wool)
plot(warp.emm)

plot(warp.emm, PIs = TRUE, comparisons = TRUE)

with_emm_options(gg.theme = ggplot2::theme_dark(), 
    plot(warp.emm, PIs = TRUE, comparisons = TRUE))

plot(warp.emm, by = NULL, comparisons = TRUE, adjust = "none", 
     horizontal = FALSE, colors = "blue")

### Using a transformed scale (also demonstrating 'facetlab' argument)
pigs.lm <- lm(log(conc + 2) ~ source * factor(percent), data = pigs)
pigs.emm <- emmeans(pigs.lm, ~ percent | source)
plot(pigs.emm, type = "scale", breaks = seq(20, 100, by = 10), 
     facetlab = "label_value")

# Based on a summary. 
# To get a transformed axis, must specify 'scale'; but it does not necessarily
# have to be the same as the actual response transformation
pigs.ci <- confint(pigs.emm, type = "response")
plot(pigs.ci, scale = scales::log10_trans(), 
     facetlab = \(x) ggplot2::label_both(x, sep = " = "))
}
