% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{epitraxr_config}
\alias{epitraxr_config}
\title{Create epitraxr config object}
\usage{
epitraxr_config(
  current_population = 1e+05,
  avg_5yr_population = 1e+05,
  rounding_decimals = 2,
  generate_csvs = TRUE,
  trend_threshold = 0.15
)
}
\arguments{
\item{current_population}{Integer. Defaults to 100,000.}

\item{avg_5yr_population}{Integer. Defaults to 100,000.}

\item{rounding_decimals}{Integer. Defaults to 2.}

\item{generate_csvs}{Logical. Defaults to TRUE.}

\item{trend_threshold}{Numeric. Defaults to 0.15.}
}
\value{
A named list with 'keys' corresponding to config options.
}
\description{
\code{epitraxr_config} creates a list of configuration options used for generating
reports.
}
\examples{
epitraxr_config(
  current_population = 56000,
  avg_5yr_population = 57000,
  rounding_decimals = 3,
  generate_csvs = FALSE,
  trend_threshold = 0.2
)
}
