% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{get_health_states_from_dimensions}
\alias{get_health_states_from_dimensions}
\alias{getHealthStatesFromDimensions}
\title{Get five digit health states from dimension scores}
\usage{
get_health_states_from_dimensions(
  scores,
  version = "5L",
  ignore.invalid = TRUE,
  dimensions = .get_dimension_names()
)
}
\arguments{
\item{scores}{a data.fram containing each dimension in a column}

\item{version}{3L, 5L or Y. Used for validating scores when ignore.invalid 
is FALSE.}

\item{ignore.invalid}{whether to ignore invalid scores. TRUE returns NA, FALSE throws an 
error.}

\item{dimensions}{character vector specifying "dimensions" column names. Defaults 
are "MO", "SC", "UA", "PD" and "AD".}
}
\value{
A character vector of individual dimension scores.
}
\description{
Merge MO, SC, UA, PD and AD dimension scores to get five digit health states.
}
\examples{
scores <- data.frame(MO=c(1,1,1,1,1),SC=c(1,2,1,2,1),
                     UA=c(1,2,3,2,1),PD=c(3,2,1,2,3),AD=c(3,3,3,3,3))
get_health_states_from_dimensions(scores, version="5L")

}
