% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_obj_links.R
\name{display.obj.links}
\alias{display.obj.links}
\title{Display patient objects links}
\usage{
display.obj.links(
  pat,
  obj.selected = NULL,
  exclusion = NULL,
  square = "rtdose",
  group.by.connected.FoR = TRUE,
  interactive = FALSE,
  random.seed = 314
)
}
\arguments{
\item{pat}{"patient" class object, as loaded using \link[espadon]{load.patient.from.dicom},
\link[espadon]{load.patient.from.Rdcm} or \link[espadon]{toy.load.patient}.}

\item{obj.selected}{Dataframe (default to NULL) containing the objects already selected,
created by a previous call of \code{display.obj.links} for example.}

\item{exclusion}{Vector of patient file modalities that should not be displayed,
as for instance \code{"mr"}...}

\item{square}{Vector of patient file modalities that should be enclosed by a
square, as for instance \code{c ("ct", "mr")}...
If \code{NULL} no object name is squared.}

\item{group.by.connected.FoR}{Boolean. If \code{TRUE} (default), all objects
sharing the same frame of reference or connected by a registration matrix have
the same color. If \code{group.by.connected.FoR =FALSE}, only objects sharing
the same FoR have the same color.}

\item{interactive}{Boolean. If \code{interactive = TRUE}, buttons are available
on the graph to get information about the objects and select or remove them from
the data frame of the selected objects.
Then simply click on the name of the object on which to apply the chosen action.
If \code{interactive = FALSE} no interaction possible with the plot.}

\item{random.seed}{Positive Integer or \code{NULL}. If \code{random.seed = NULL},
the objects are laid out randomly. The layout is otherwise fixed.}
}
\value{
The function displays all patient objects, linked by an
arrow when they are connected or a line when they belongs to the same DICOM
object, and with a color and a shape depending on \code{square}, \code{group.by.connected.FoR}.

When \code{interactive = TRUE}, it returns a dataframe of the selected objects,
or NULL if no object is selected.

Items are circled in green when the DICOM file has been approved.
They are circled in red, when the DICOM series is incomplete (e.g. missing plan).
}
\description{
The \code{display.obj.links} function displays a graph of
connections between objects of a patient.
The name of the objects corresponds to their modality (ct, mr, rtdose...)
followed by their position in their respective lists in the patient list objects.
Connected objects are linked by arrows. Objects sharing the same frame of reference
have the same color except for objects with warnings, errors or missing planes
which are all in grey.
Approved objects are circled in green.
By default, objects shapes are circles, except rtdose represented as squares.
}
\examples{
# loading of toy-patient objects
patient <- toy.load.patient (dxyz = c (5, 5, 5), beam.nb = 1)
display.obj.links (patient, group.by.connected.FoR = FALSE)
display.obj.links (patient, group.by.connected.FoR = TRUE)
display.obj.links (patient, group.by.connected.FoR = TRUE, random.seed=NULL)
}
\seealso{
\link[espadon]{get.obj.connection}
}
