% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_palette.R
\name{display.palette}
\alias{display.palette}
\title{Display of the color scale of a color palette}
\usage{
display.palette(
  col,
  breaks = NULL,
  factors = NULL,
  override.breaks = FALSE,
  new.window = FALSE,
  ...
)
}
\arguments{
\item{col}{Vector of colors like the ones generated by \code{rainbow},
\code{heat.colors}, etc.}

\item{breaks}{Vector of breaks for the color palette. It is the usual option
for images or dose, for instance. Its length must be one unit more than \code{col} length.}

\item{factors}{Vector containing the labels associated to each \code{col}. It should be used for
tissue identification or image segment labelling. Its length must be \code{col} length.}

\item{override.breaks}{Boolean. When \code{FALSE} (by default) ordinates are set to breaks. when \code{TRUE}
colors are uniformely displayed, and associated breaks set to the correct ordinates for the given colors.}

\item{new.window}{Boolean. If \code{TRUE}, it opens a new window for displaying
the palette.}

\item{...}{others parameters of plot or axis functions}
}
\value{
Returns in a new device (if \code{new.window = TRUE}), or in the
active graphics window  (if \code{new.window = FALSE}), the palette color defined
by \code{col} and \code{breaks} in priority, or by \code{col} and \code{factors}.
}
\description{
The \code{Display.palette} function displays the color scale as it is used for representations
in espadon functions
}
\note{
the breaks are not necessarily evenly spaced. In this case, the colour palette
can be represented as the breaks are defined (default option) or by choosing a
constant spacing for each colour and displaying the associated abscissa
calculated from the breaks (override.breaks = TRUE).
}
\examples{
\dontrun{                
# simple example for breaks and factors

display.palette (c ("red", "green", "blue"), breaks = c(0, 1, 3, 7), 
                 ylab = "a simple color palette")
display.palette (c ("red", "green", "blue"), breaks = c(0, 1, 3, 7), 
                 override.breaks = TRUE)
display.palette (c ("red", "green", "blue"), 
                 factors = c("red", "green", "blue"))
display.palette (c ("grey", "green", "blue"), factors = c(NA, 1, 2))

# for RVV palette, the function computes breaks between -1000 and 1000
display.palette (pal.RVV (255), new.window = TRUE)

# a palette for dose, for instance
display.palette (rainbow (255, start = 0, end = 4/6, rev = TRUE), 
                 breaks = seq (0, 60, length.out = 256), new.window = TRUE)

# black & white palette for CTs or MRs
display.palette (grey.colors (255, start = 0, end = 1), 
                 breaks = seq (0, 60, length.out = 256), new.window = TRUE)

# transparency affects colors depending on background (black in first exemple,
# white in the second one)
display.palette (pal.rainbow(255), breaks = seq (0, 60, length.out=256))
display.palette (pal.rainbow(255), breaks = seq (0, 60, length.out=256), 
                 bg = "white", new.window = TRUE)
}                         
# colors contracted range using non uniform breaks in the plot window
display.palette (pal.rainbow(255),
                 breaks = seq (0, 1, length.out = 256)^0.25 * 60, bg="grey", 
                 new.window = FALSE)

# the same using breaks override
display.palette (pal.rainbow(255),
                 breaks = seq (0, 1, length.out = 256)^0.25 * 60, bg="grey", 
                 override.breaks = TRUE, new.window = FALSE)

}
