% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extinction_probability_di.R
\name{extinction_probability_di}
\alias{extinction_probability_di}
\alias{ext_prob_di}
\alias{log_ext_prob_di}
\alias{log_ext_comp_di}
\alias{ext_prob_format_di}
\title{Computes Extinction Probability for a Density-Independent Model}
\usage{
ext_prob_di(w, z)

log_ext_prob_di(w, z)

log_ext_comp_di(w, z)

ext_prob_format_di(w, z, digits = 5L)
}
\arguments{
\item{w}{Numeric; transformed parameter
\eqn{w=(\mu t+x_d)/(\sigma\sqrt{t})}.}

\item{z}{Numeric; transformed parameter
\eqn{z=(-\mu t+x_d)/(\sigma\sqrt{t})}.}

\item{digits}{Integer; significant digits for formatting (only for
\code{ext_prob_format_di}).}
}
\value{
For \code{ext_prob_di}: numeric scalar \eqn{G(w,z)}.\cr
For \code{log_ext_prob_di}: numeric scalar \eqn{\log G(w,z)}.\cr
For \code{log_ext_comp_di}: numeric scalar \eqn{\log Q(w,z)}.\cr
For \code{ext_prob_format_di}: character string formatted for display.
}
\description{
Compute \eqn{G(w,z)} and its complement \eqn{Q(w,z)=1-G(w,z)} for a
density-independent (drifted Wiener) model, on both linear and log scales.
}
\details{
For any \eqn{t>0} with \eqn{w+z>0},
\deqn{
  \Pr[T \leq t] = G(w,z)=\Phi(-w)+
  \exp\!\left(\tfrac{z^2-w^2}{2}\right)\Phi(-z), \qquad
  Q(w,z)=1-G(w,z).
}
Here \eqn{\Phi} and \eqn{\phi} denote the standard normal CDF and PDF.

\strong{Stability strategy.}
(i) For large \eqn{z}, rewrite the product
\eqn{\exp((z^2-w^2)/2)\,\Phi(-z)} via the Mills ratio and replace it by an
8-term asymptotic series when \eqn{z \ge 19}.
(ii) On the log scale, use log-sum-exp and a stable log-difference
(\code{log1mexp}) built from \code{log1p}/\code{expm1} to retain tail info.

\strong{Domain.} Scalar inputs are assumed and require \eqn{w+z>0}.

\strong{Functions.}
\itemize{
\item \code{ext_prob_di(w,z)}: returns \eqn{G(w,z)} (linear scale).
\item \code{log_ext_prob_di(w,z)}: returns \eqn{\log G(w,z)}.
\item \code{log_ext_comp_di(w,z)}: returns \eqn{\log Q(w,z)}.
\item \code{ext_prob_format_di(w,z,digits)}: formats a point estimate
using \code{repr_mode()} and \code{format_by_mode()}.
}
}
\seealso{
\code{\link{statistics_di}}, \code{\link{repr_mode}},
\code{\link{format_by_mode}}
}
\author{
Hiroshi Hakoyama, \email{hiroshi.hakoyama@gmail.com}
}
\keyword{internal}
