% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openapi.R
\name{prune_openapi}
\alias{prune_openapi}
\title{Ensure consistency of OpenAPI auth description}
\usage{
prune_openapi(doc)
}
\arguments{
\item{doc}{A list describing a full OpenAPI documentation}
}
\value{
The \code{doc} modified so the auth descriptions are internally consistent
}
\description{
Prune an OpenAPI doc so that security descriptions only contains references
to the schemes defined in \code{securitySchemes} and only contains scopes for the
schemes that are OAuth2.0 and OpenID. For OAuth2.0 specifically, scopes are
removed if they are not explicitly named in \code{securitySchemes}.
}
\examples{
# OpenAPI stub only containing relevant info for example
openapi <- list(
  components = list(
    securitySchemes = list(
      auth1 = list(
        type = "http",
        scheme = "basic"
      ),
      auth2 = list(
        type = "oauth2",
        flows = list(
          authorizationCode = list(
            scopes = list(
              read = "read data",
              write = "change data"
            )
          )
        )
      )
    )
  ),
  # Global auth settings
  security = list(
    list(auth1 = c("read", "write"))
  ),
  # Path specific auth settings
  paths = list(
    "/user/{username}" = list(
      get = list(
        security = list(
          list(auth2 = c("read", "write", "commit")),
          list(auth3 = c("read"))
        )
      )
    )
  )
)

prune_openapi(openapi)

}
