% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf-functions.R
\name{hrf_gamma}
\alias{hrf_gamma}
\title{Gamma HRF (hemodynamic response function)}
\usage{
hrf_gamma(t, shape = 6, rate = 1)
}
\arguments{
\item{t}{A vector of time points.}

\item{shape}{A numeric value representing the shape parameter for the gamma probability density function. Default value is 6.}

\item{rate}{A numeric value representing the rate parameter for the gamma probability density function. Default value is 1.}
}
\value{
A numeric vector representing the gamma HRF at the given time points `t`.
}
\description{
The `hrf_gamma` function computes the gamma density-based HRF (hemodynamic response function) at given time points `t`.
}
\examples{
# Compute the gamma HRF representation for time points from 0 to 20 with 0.5 increments
hrf_gamma_vals <- hrf_gamma(seq(0, 20, by = .5), shape = 6, rate = 1)
}
\seealso{
Other hrf_functions: 
\code{\link{hrf_basis_lwu}()},
\code{\link{hrf_boxcar}()},
\code{\link{hrf_bspline}()},
\code{\link{hrf_gaussian}()},
\code{\link{hrf_inv_logit}()},
\code{\link{hrf_lwu}()},
\code{\link{hrf_mexhat}()},
\code{\link{hrf_sine}()},
\code{\link{hrf_spmg1}()},
\code{\link{hrf_time}()},
\code{\link{hrf_weighted}()}
}
\concept{hrf_functions}
