% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\name{dot-has_column}
\alias{dot-has_column}
\alias{.has_column}
\alias{.has_column.SQLiteConnection}
\alias{.has_column.PqConnection}
\alias{.has_column.MariaDBConnection}
\alias{.has_column.Microsoft SQL Server}
\alias{.has_column.duckdb_connection}
\alias{.has_column.default}
\title{Check if a column exists in a table (S3 generic)}
\usage{
.has_column(conn, table_name, column_name)

\method{.has_column}{SQLiteConnection}(conn, table_name, column_name)

\method{.has_column}{PqConnection}(conn, table_name, column_name)

\method{.has_column}{MariaDBConnection}(conn, table_name, column_name)

\method{.has_column}{`Microsoft SQL Server`}(conn, table_name, column_name)

\method{.has_column}{duckdb_connection}(conn, table_name, column_name)

\method{.has_column}{default}(conn, table_name, column_name)
}
\arguments{
\item{conn}{Database connection (DBIConnection)}

\item{table_name}{Character. Name of the table}

\item{column_name}{Character. Name of the column to check}
}
\value{
Logical. TRUE if column exists, FALSE otherwise
}
\description{
Cross-database method to check if a column exists in a table.
Uses database-specific introspection methods via S3 dispatch.
}
\section{Functions}{
\itemize{
\item \code{.has_column(SQLiteConnection)}: SQLite implementation using PRAGMA

\item \code{.has_column(PqConnection)}: PostgreSQL implementation using information_schema

\item \code{.has_column(MariaDBConnection)}: MySQL/MariaDB implementation using information_schema

\item \code{.has_column(`Microsoft SQL Server`)}: SQL Server implementation using information_schema

\item \code{.has_column(duckdb_connection)}: DuckDB implementation using information_schema

\item \code{.has_column(default)}: Default implementation for unknown database types

}}
\examples{
\donttest{
if (FALSE) {
conn <- connection_get("my_db")
has_deleted_at <- .has_column(conn, "users", "deleted_at")
DBI::dbDisconnect(conn)
}
}
}
\keyword{internal}
