% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmrcc.R
\name{estimate_mixture}
\alias{estimate_mixture}
\title{Performs the estimation of gaussian mixtures of regression models and gaussian mixture models.
Used in FMRCC_PhaseI.}
\usage{
estimate_mixture(
  y = NULL,
  x = NULL,
  ninit = 10,
  groups = 1:5,
  mode = "regression",
  intercept = TRUE,
  init_met = "kmeans",
  sigma_par = c("VVV", "EEE", "VII", "EII")
)
}
\arguments{
\item{y}{a matrix with the scores of the response variable}

\item{x}{a matrix with the scores of the covariates}

\item{ninit}{the number of random starts for the model estimation. It is ignored if init_met = 'kmeans'. Default is 10}

\item{groups}{the number of groups to consider in the model estimation. Default is 1:3}

\item{mode}{the type of model to estimate, it can be 'regression' or 'clustering'. Default is 'regression'}

\item{intercept}{logical, if TRUE the model includes an intercept. Default is TRUE}

\item{init_met}{the method to initialize the model, it can be 'kmeans' or 'random'. Default is 'kmeans'}

\item{sigma_par}{the covariance parametrization to consider in the model estimation. Default is c('VVV','EEE','VII','EII')}
}
\value{
a list with the model estimated, the residuals variance matrix and the BIC values
}
\description{
Performs the estimation of gaussian mixtures of regression models and gaussian mixture models.
Used in FMRCC_PhaseI.
}
