% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictData.R
\name{PredictData}
\alias{PredictData}
\title{PredictData Class}
\description{
This class implements \link{PredictData} object to be predicted.
A \link{PredictData} object can only exist as a component of a \link{PredictLayer} or a \link{PredictMetaLayer} object.
}
\seealso{
\link{TrainData}, \link{TestData}
}
\section{Super class}{
\code{\link[fuseMLR:Data]{fuseMLR::Data}} -> \code{PredictData}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PredictData-new}{\code{PredictData$new()}}
\item \href{#method-PredictData-print}{\code{PredictData$print()}}
\item \href{#method-PredictData-getPredictData}{\code{PredictData$getPredictData()}}
\item \href{#method-PredictData-getPredictLayer}{\code{PredictData$getPredictLayer()}}
\item \href{#method-PredictData-setPredictLayer}{\code{PredictData$setPredictLayer()}}
\item \href{#method-PredictData-clone}{\code{PredictData$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getCompleteData"><a href='../../fuseMLR/html/Data.html#method-Data-getCompleteData'><code>fuseMLR::Data$getCompleteData()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getData"><a href='../../fuseMLR/html/Data.html#method-Data-getData'><code>fuseMLR::Data$getData()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getDataFrame"><a href='../../fuseMLR/html/Data.html#method-Data-getDataFrame'><code>fuseMLR::Data$getDataFrame()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getId"><a href='../../fuseMLR/html/Data.html#method-Data-getId'><code>fuseMLR::Data$getId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getIndCol"><a href='../../fuseMLR/html/Data.html#method-Data-getIndCol'><code>fuseMLR::Data$getIndCol()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getIndSubset"><a href='../../fuseMLR/html/Data.html#method-Data-getIndSubset'><code>fuseMLR::Data$getIndSubset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getSetDiff"><a href='../../fuseMLR/html/Data.html#method-Data-getSetDiff'><code>fuseMLR::Data$getSetDiff()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getVarSubset"><a href='../../fuseMLR/html/Data.html#method-Data-getVarSubset'><code>fuseMLR::Data$getVarSubset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="impute"><a href='../../fuseMLR/html/Data.html#method-Data-impute'><code>fuseMLR::Data$impute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="setDataFrame"><a href='../../fuseMLR/html/Data.html#method-Data-setDataFrame'><code>fuseMLR::Data$setDataFrame()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictData-new"></a>}}
\if{latex}{\out{\hypertarget{method-PredictData-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new object from the current class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictData$new(id, ind_col, data_frame)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character} \cr
Object ID.}

\item{\code{ind_col}}{\code{character}\cr
Column name containing individual IDs.}

\item{\code{data_frame}}{\code{data.frame}\cr
\code{data.frame} containing data.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictData-print"></a>}}
\if{latex}{\out{\hypertarget{method-PredictData-print}{}}}
\subsection{Method \code{print()}}{
Printer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictData$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictData-getPredictData"></a>}}
\if{latex}{\out{\hypertarget{method-PredictData-getPredictData}{}}}
\subsection{Method \code{getPredictData()}}{
Getter of the current predicted \code{data.frame} wihtout individual
ID variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictData$getPredictData()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \code{data.frame} without individual ID nor target variables is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictData-getPredictLayer"></a>}}
\if{latex}{\out{\hypertarget{method-PredictData-getPredictLayer}{}}}
\subsection{Method \code{getPredictLayer()}}{
Getter of the current layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictData$getPredictLayer()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The layer (from class \link{PredictLayer}) on which the current train data are stored
is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictData-setPredictLayer"></a>}}
\if{latex}{\out{\hypertarget{method-PredictData-setPredictLayer}{}}}
\subsection{Method \code{setPredictLayer()}}{
Assigns a predicted layer to the predicted data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictData$setPredictLayer(predict_layer)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{predict_layer}}{\code{PredictLayer(1)} \cr}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The current object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictData-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PredictData-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictData$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
