% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attachData.R
\name{attachData}
\alias{attachData}
\title{Attach data to a widget.}
\usage{
attachData(widget, data, file, url, ...)
}
\arguments{
\item{widget}{A widget created with \code{\link[htmlwidgets]{createWidget}}.}

\item{data}{a \code{nanoarrow_array_stream} as created with
\code{\link[nanoarrow]{as_nanoarrow_array_stream}}. If supplied, \code{file} and
\code{url} are ignored.}

\item{file}{A local file path to a data file to be attached to the widget.
Ignored if \code{data} is supplied.}

\item{url}{A URL to a file to be attached to the widget. Ignored if
\code{data} or \code{file} is supplied.}

\item{...}{further arguments supplied to internal methods. The most relevant
argument is \code{name} which can be used to set the \code{id} of the attachment. See
\code{details} and \code{examples} for further explanation.}
}
\value{
The \code{widget} with the data attached.
}
\description{
Pipe-friendly function to attach data (any, really, not only \code{geoarrow}) to a
widget created with \code{\link[htmlwidgets]{createWidget}}.
}
\details{
The provided data will be attached to the page created by the widget as a \verb{<link>}.
It can then be used by some script that will \code{fetch} this data from the \code{href}.
See e.g. the \code{"Use geoarrowWidget with an existing widget"} vignette of this package
for an example of how to work with this data using \code{\link[htmlwidgets]{onRender}}
or the \href{https://github.com/r-spatial/geoarrowWidget/blob/master/inst/htmlwidgets/geoarrowDummyWidget.js#L33-L42}{source of geoarrowDummyWidget.js}
for another, similar example.

NOTE that the \verb{<link>} id can be controlled by supplying a \code{name} argument
(via \code{...}). This will the be prepended to \verb{<name>-geoarrowWidget-attachment}.
See example below, where the name "mydata" is used to create the id
"mydata-geoarrowWidget-attachment".
In case no \code{name} is supplied, it defaults to the file name (without extension)
that is supplied via \code{file} or \code{url}.
}
\examples{
library(listviewer)

wgt = jsonedit(
  list("Just some dummy text")
  , elementId = "lv-example"
)
attachData(
  wgt
  , url = "https://geoarrow-test.s3.eu-central-1.amazonaws.com/test_layer_interleaved.arrow"
 , name = "mydata"
)

## open the resulting page in the browser and inspect the page source, e.g.
## by pressing <Ctrl + u>. You should see a line like (href is shortened here):

# <link id="mydata-geoarrowWidget-attachment" rel="attachment" href="https://geoarrow-test.s3...."/>

}
