% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monograf_bib.R
\name{monograf_bib}
\alias{monograf_bib}
\title{Function for preparing metadata of the main monographs for automatic insertion into scientific articles}
\usage{
monograf_bib(input_date, input_tam)
}
\arguments{
\item{input_date}{is a dataframe with the scientific production database in the form of a monograph}

\item{input_tam}{is the length of the dataframe with the main monographs, obtained using package bibliorefer.}
}
\value{
The output of the monograf_bib function is the file with the .bib extension, containing the list of monograph references in BibTex format, prepared to be automatically included in the list of references of a scientific article.
}
\description{
The monograf_bib function prepares the metadata of the main monographs to be automatically included in a scientific article. The monograf_bib function internally calls two support functions. The output of the monograf_bib function is the file with the .bib extension, containing the list of monograph references in BibTex format, prepared to be automatically included in the scientific reference list.
}
\examples{

# Example 1 - Concatenated position article

# File of database
file_db <- system.file("extdata","monograf.csv", package = "gerefer")
separator <- ";"

# Parameters of the function
input_date <- example_database(file_db, separator)
input_tam <- 10

#Calls the function monograf_bib
monograflister_bibtex <- monograf_bib(input_date, input_tam)
monograflister_bibtex


}
\references{
1 - Aria, M. & Cuccurullo, C. (2017) bibliometrix: An R-tool for comprehensive science mapping analysis, Journal of Informetrics, 11(4), pp 959-975, Elsevier.
2 - Bibliometric indicators to evaluate scientific activity. C García-Villar, J M García-Santos. Radiologia (Engl Ed). 2021 May-Jun;63(3):228-235.
}
