% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/girafe_options.R
\name{opts_toolbar}
\alias{opts_toolbar}
\title{Toolbar settings}
\usage{
opts_toolbar(
  position = c("topright", "top", "bottom", "topleft", "bottomleft", "bottomright"),
  saveaspng = TRUE,
  pngname = "diagram",
  tooltips = NULL,
  hidden = NULL,
  fixed = FALSE,
  delay_mouseover = 200,
  delay_mouseout = 500
)
}
\arguments{
\item{position}{Position of the toolbar relative to the plot.
One of 'top', 'bottom', 'topleft', 'topright', 'bottomleft', 'bottomright'}

\item{saveaspng}{Show (TRUE) or hide (FALSE) the 'download png' button.}

\item{pngname}{The default basename (without .png extension) to use for the png file.}

\item{tooltips}{A named list with tooltip labels for the buttons,
for adapting to other language. Passing NULL will use the default tooltips:

list(
lasso_select = 'lasso selection',
lasso_deselect = 'lasso deselection',
zoom_on = 'activate pan/zoom',
zoom_off = 'deactivate pan/zoom',
zoom_rect = 'zoom with rectangle',
zoom_reset = 'reset pan/zoom',
saveaspng = 'download png'
)}

\item{hidden}{A character vector with the names of the buttons or button groups to be hidden
from the toolbar. This allows full customization of which buttons appear.

Valid button groups: 'selection', 'zoom', 'misc'

Valid button names: 'lasso_select', 'lasso_deselect', 'zoom_onoff', 'zoom_rect', 'zoom_reset', 'saveaspng'}

\item{fixed}{if FALSE (default), the toolbar will float above the graphic, if
TRUE, the toolbar will be fixed and always visible.}

\item{delay_mouseover}{The duration in milliseconds of the
transition associated with toolbar display.}

\item{delay_mouseout}{The duration in milliseconds of the
transition associated with toolbar end of display.}
}
\description{
Allows customization of the toolbar
}
\note{
\code{saveaspng} relies on JavaScript promises, so any browsers that don't natively
support the standard Promise object will need to have a polyfill (e.g.
Internet Explorer with version less than 11 will need it).
}
\examples{
library(ggiraph)
library(ggplot2)

dataset <- mtcars
dataset$carname <- row.names(mtcars)

gg <- ggplot(
  data = dataset,
  mapping = aes(
    x = wt, y = qsec, color = disp,
    tooltip = carname, data_id = carname
  )
) +
  geom_point_interactive() +
  theme_minimal()

x <- girafe(
  ggobj = gg,
  options = list(
    opts_zoom(max = 5),
    opts_selection(only_shiny = FALSE),
    opts_toolbar(position = "top")
  )
)
if (interactive()) print(x)

# Hide lasso selection tools (useful in Shiny when selections
# are controlled by other app interactions)
x <- girafe(
  ggobj = gg,
  options = list(
    opts_zoom(max = 5),
    opts_selection(only_shiny = FALSE),
    opts_toolbar(
      position = "top",
      hidden = c("lasso_select", "lasso_deselect")
    )
  )
)
if (interactive()) print(x)


# Keep only zoom/pan and reset, hide rectangular zoom
x <- girafe(
  ggobj = gg,
  options = list(
    opts_zoom(max = 5),
    opts_selection(only_shiny = FALSE),
    opts_toolbar(
      position = "top",
      hidden = c("selection", "zoom_rect", "saveaspng")
    )
  )
)
if (interactive()) print(x)
}
\seealso{
Other girafe animation options: 
\code{\link{girafe_defaults}()},
\code{\link{girafe_options}()},
\code{\link{init_girafe_defaults}()},
\code{\link{opts_hover}()},
\code{\link{opts_selection}()},
\code{\link{opts_sizing}()},
\code{\link{opts_tooltip}()},
\code{\link{opts_zoom}()},
\code{\link{set_girafe_defaults}()}
}
\concept{girafe animation options}
