% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation_compass.R, R/compass_styles.R
\name{north_arrow_classic}
\alias{north_arrow_classic}
\alias{compass_sinan}
\alias{compass-styles}
\alias{north_arrow_solid}
\alias{compass_rose_simple}
\alias{compass_rose_classic}
\alias{compass_rose_circle}
\alias{compass_guiding_fish}
\title{Classic North Arrow Style (Minimal)}
\usage{
north_arrow_classic(
  fill = c("white", "black"),
  line_col = "black",
  line_width = 2,
  text_col = "black",
  text_size = 12,
  text_face = "plain",
  text_family = ""
)

compass_sinan(
  line_col = "black",
  square_pad = 0.1,
  ring_outer = 0.35,
  ring_ratio = 0.65,
  labels = c("N", "E", "S", "W"),
  text_size = 12,
  text_face = "plain",
  text_family = "",
  text_col = "black",
  label_offset = 0.05,
  spoon_fill = "black",
  spoon_col = "black",
  spoon_scale = 0.8,
  inner_fill = "lightgrey",
  square_width = 2,
  outer_width = 2,
  inner_width = 1,
  spoon_width = 1
)

north_arrow_classic(
  fill = c("white", "black"),
  line_col = "black",
  line_width = 2,
  text_col = "black",
  text_size = 12,
  text_face = "plain",
  text_family = ""
)

north_arrow_solid(
  fill = "black",
  line_col = "black",
  line_width = 1,
  text_col = "black",
  text_size = 12,
  text_face = "plain",
  text_family = ""
)

compass_rose_simple(
  fill = c("white", "black"),
  line_col = "black",
  line_width = 1,
  sharpness = 0.7,
  text_col = "black",
  text_size = 12,
  text_face = "plain",
  text_family = ""
)

compass_rose_classic(
  fill = c("white", "black"),
  line_col = "black",
  line_width = 1.5,
  sharpness = 0.6,
  text_col = "black",
  text_size = 12,
  text_face = "plain",
  text_family = ""
)

compass_rose_circle(
  fill = "white",
  line_col = "black",
  line_width = 3,
  text_col = "black",
  text_size = 12,
  text_face = "plain",
  text_family = ""
)

compass_guiding_fish(
  size = 1,
  ring_ratio = 0.2,
  ring_width = 2,
  n_seg = 16,
  fish_col = "black",
  fish_shift = -0.03,
  text_col = "black",
  text_size = 12,
  text_face = "plain",
  text_family = ""
)

compass_sinan(
  line_col = "black",
  square_pad = 0.1,
  ring_outer = 0.35,
  ring_ratio = 0.65,
  labels = c("N", "E", "S", "W"),
  text_size = 12,
  text_face = "plain",
  text_family = "",
  text_col = "black",
  label_offset = 0.05,
  spoon_fill = "black",
  spoon_col = "black",
  spoon_scale = 0.8,
  inner_fill = "lightgrey",
  square_width = 2,
  outer_width = 2,
  inner_width = 1,
  spoon_width = 1
)
}
\arguments{
\item{fill}{Fill color(s) for polygons. Vectorized for alternating fills in some styles.}

\item{line_col}{Stroke color for outlines.}

\item{line_width}{Stroke width for outlines (numeric).}

\item{text_col}{Text color for labels.}

\item{text_size}{Text font size for labels (points).}

\item{text_face}{Text font face (e.g., "plain", "bold").}

\item{text_family}{Text font family.}

\item{square_pad}{Padding around the outer square (Sinan style), fraction of box side.}

\item{ring_outer}{Outer ring radius (Sinan style), expressed in npc units (0..1).}

\item{ring_ratio}{Inner/outer radius ratio for ringed styles (0 < value < 1).}

\item{labels}{Character vector of cardinal labels, usually `c("N","E","S","W")`.}

\item{label_offset}{Label offset from the square edges (Sinan style), npc units.}

\item{spoon_fill}{Fill color for spoon glyph (Sinan style).}

\item{spoon_col}{Stroke color for spoon glyph (Sinan style).}

\item{spoon_scale}{Scale factor for spoon glyph (Sinan style).}

\item{inner_fill}{Fill color for inner disk (Sinan style).}

\item{square_width, outer_width, inner_width, spoon_width}{Stroke widths for respective elements in Sinan style.}

\item{sharpness}{Controls star-point sharpness in rose styles, numeric in [0, 1].}

\item{size}{Global size scaler (used by some styles).}

\item{ring_width}{Stroke width of ring outlines (numeric).}

\item{n_seg}{Number of ring segments (integer).}

\item{fish_col}{Fill color for fish shape (guiding fish style).}

\item{fish_shift}{Vertical shift for fish shape (guiding fish style).}
}
\value{
A `grid` graphical object (grob).
}
\description{
A collection of style constructors that return `grid` grobs for use with
`annotation_compass(style = ...)`. These styles provide different visual
appearances for a compass or north arrow drawn as an annotation.
}
\details{
Exported constructors documented under this topic:
\itemize{
  \item \code{north_arrow_classic()}
  \item \code{north_arrow_solid()}
  \item \code{compass_rose_simple()}
  \item \code{compass_rose_classic()}
  \item \code{compass_rose_circle()}
  \item \code{compass_guiding_fish()}
  \item \code{compass_sinan()}
}

Each constructor returns a grob ready to be passed to \code{annotation_compass(style = ...)}.
All styles include an "N" (or cardinal labels) to indicate north.
}
\examples{
# Standalone preview
grid::grid.newpage(); grid::grid.draw(north_arrow_classic())
grid::grid.newpage(); grid::grid.draw(north_arrow_solid())
grid::grid.newpage(); grid::grid.draw(compass_rose_simple())
grid::grid.newpage(); grid::grid.draw(compass_rose_classic())
grid::grid.newpage(); grid::grid.draw(compass_rose_circle())
grid::grid.newpage(); grid::grid.draw(compass_guiding_fish())
grid::grid.newpage(); grid::grid.draw(compass_sinan())

# Use in ggplot
\donttest{
if (requireNamespace("ggplot2", quietly = TRUE) &&
    requireNamespace("sf", quietly = TRUE)) {
  nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)
  p <- ggplot2::ggplot() +
    ggplot2::geom_sf(data = nc, fill = "grey90") +
    ggplot2::theme_minimal()

  p + annotation_compass(location = "tr", style = north_arrow_classic())
  p + annotation_compass(location = "bl", style = compass_sinan())
}
}

}
\seealso{
[annotation_compass] for adding the compass to a ggplot.
}
