% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggPedigreeInteractive.R
\name{ggPedigreeInteractive}
\alias{ggPedigreeInteractive}
\title{Interactive pedigree plot (Plotly wrapper around ggPedigree)}
\usage{
ggPedigreeInteractive(
  ped,
  famID = "famID",
  personID = "personID",
  momID = "momID",
  dadID = "dadID",
  patID = "patID",
  matID = "matID",
  twinID = "twinID",
  spouseID = "spouseID",
  status_column = NULL,
  tooltip_columns = NULL,
  focal_fill_column = NULL,
  overlay_column = NULL,
  config = list(optimize_plotly = TRUE),
  debug = FALSE,
  return_widget = TRUE,
  hints = NULL,
  code_male = NULL,
  sexVar = "sex"
)
}
\arguments{
\item{ped}{A data frame containing the pedigree data. Needs personID, momID, dadID, and sex columns.}

\item{famID}{Character string specifying the column name for family IDs. Defaults to "famID".}

\item{personID}{Character string specifying the column name for individual IDs. Defaults to "personID".}

\item{momID}{Character string specifying the column name for mother IDs. Defaults to "momID".}

\item{dadID}{Character string specifying the column name for father IDs. Defaults to "dadID".}

\item{patID}{Character string specifying the column name for paternal lines Defaults to "patID".}

\item{matID}{Character string specifying the column name for maternal lines Defaults to "matID".}

\item{twinID}{Character string specifying the column name for twin IDs. Defaults to "twinID".}

\item{spouseID}{Character string specifying the column name for spouse IDs. Defaults to "spouseID".}

\item{status_column}{Character string specifying the column name for affected status. Defaults to NULL.}

\item{tooltip_columns}{Character vector of column names to show when hovering.
Defaults to c("personID", "sex").  Additional columns present in `ped`
can be supplied – they will be added to the Plotly tooltip text.
Defaults to NULL, which uses the default tooltip columns.}

\item{focal_fill_column}{Character string specifying the column name for focal fill color.}

\item{overlay_column}{Character string specifying the column name for overlay alpha values.}

\item{config}{A list of configuration options for customizing the plot.
      See getDefaultPlotConfig for details of each option. The list can include:
\describe{
   \item{code_male}{Integer or string. Value identifying males in the sex column. (typically 0 or 1) Default: 1}
   \item{segment_spouse_color, segment_self_color}{Character. Line colors for respective connection types.}
   \item{segment_sibling_color, segment_parent_color, segment_offspring_color}{Character. Line colors for respective connection types.}
   \item{label_text_size, point_size, segment_linewidth}{Numeric. Controls text size, point size, and line thickness.}
   \item{generation_height}{Numeric. Vertical spacing multiplier between generations. Default: 1.}
   \item{shape_unknown, shape_female, shape_male, status_shape_affected}{Integers. Shape codes for plotting each group.}
   \item{sex_shape_labels}{Character vector of labels for the sex variable. (default: c("Female", "Male", "Unknown"))}
   \item{unaffected, affected}{Values indicating unaffected/affected status.}
   \item{sex_color_include}{Logical. If TRUE, uses color to differentiate sex.}
   \item{label_max_overlaps}{Maximum number of overlaps allowed in repelled labels.}
   \item{label_segment_color}{Color used for label connector lines.}
 }}

\item{debug}{Logical. If TRUE, prints debugging information. Default: FALSE.}

\item{return_widget}{Logical; if TRUE (default) returns a plotly htmlwidget.
If FALSE, returns the underlying plotly object (useful for further
customization before printing).}

\item{hints}{Data frame with hints for layout adjustments. Default: NULL.}

\item{code_male}{Integer or string. Value identifying males in the sex column. (typically 0 or 1) Default: 1}

\item{sexVar}{Character string specifying the column name for sex. Defaults to "sex".}
}
\value{
A plotly htmlwidget (or plotly object if `return_widget = FALSE`)
}
\description{
Generates an interactive HTML widget built on top of the static ggPedigree
output.  All layout, styling, and connection logic are inherited from
ggPedigree(); this function simply augments the plot with Plotly hover,
zoom, and pan functionality.
}
\examples{
library(BGmisc)
data("potter")
ggPedigreeInteractive(potter, famID = "famID", personID = "personID")


data(hazard)
ggPedigreeInteractive(
  hazard,
  famID = "famID",
  personID = "ID",
  momID = "momID",
  dadID = "dadID",
  config = list(
    code_male = 0,
    status_column = "affected",
    label_nudge_y = .25,
    label_include = TRUE,
    include_tooltip = TRUE,
    label_method = "geom_text",
    sex_color_include = TRUE
  ),
  tooltip_columns = c("personID", "birthYr", "onsetYr", "deathYr")
) |>
  plotly::layout(
    title = "Hazard Pedigree (interactive)",
    hoverlabel = list(bgcolor = "white"),
    margin = list(l = 50, r = 50, t = 50, b = 50)
  ) |>
  plotly::config(displayModeBar = TRUE)
}
\seealso{
ggPedigree.core, ggPedigree, vignette("v20_interactiveplots"), vignette("v21_extendedinteractiveplots"), vignette("v32_plots_morecomplexity")
}
