% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify.prc.R
\name{fortify.prc}
\alias{fortify.prc}
\alias{tidy.prc}
\title{Fortify a \code{"prc"} object}
\usage{
\method{fortify}{prc}(model, data, scaling = "symmetric", axis = 1, ...)

\method{tidy}{prc}(x, data, scaling = "symmetric", axis = 1, ...)
}
\arguments{
\item{model, x}{an object of class \code{"prc"}, the result of a call to
\code{\link[vegan:prc]{vegan::prc()}}.}

\item{data}{currently ignored.}

\item{scaling}{the desired scaling. See \code{\link[vegan:plot.cca]{vegan::scores.cca()}} for details.}

\item{axis}{numeric; which PRC axis to extract. Default is \code{axis = 1}, which
is the most generally useful choice.}

\item{...}{additional arguments currently ignored.}
}
\value{
A data frame in long format containing the ordination scores. The
first three components are the \code{Time}, \code{Treatment}, and associated
\code{Response}. The last two components, \code{score} and \code{label} are an indicator
factor and a label for the rows for use in plotting.
}
\description{
Fortifies an object of class \code{"prc"} to produce a data frame of the selected
axis scores in long format, suitable for plotting with \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\details{
TODO
}
\examples{
library("vegan")
data(pyrifos)
week <- gl(11, 12, labels=c(-4, -1, 0.1, 1, 2, 4, 8, 12, 15, 19, 24))
dose <- factor(rep(c(0.1, 0, 0, 0.9, 0, 44, 6, 0.1, 44, 0.9, 0, 6), 11))
ditch <- gl(12, 1, length=132)

pyrifos_prc <- prc(pyrifos, dose, week)
fortify(pyrifos_prc)
}
\author{
Gavin L. Simpson
}
