% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smap.R
\name{smap_predicates}
\alias{smap_predicates}
\alias{ssome}
\alias{severy}
\alias{snone}
\title{Test Predicates on Glycan Structure Vectors}
\usage{
ssome(.x, .p, ...)

severy(.x, .p, ...)

snone(.x, .p, ...)
}
\arguments{
\item{.x}{A glycan structure vector (glyrepr_structure).}

\item{.p}{A predicate function that takes an igraph object and returns a logical value.
Can be a function, purrr-style lambda (\code{~ .x$attr}), or a character string naming a function.}

\item{...}{Additional arguments passed to \code{.p}.}
}
\value{
A single logical value.
}
\description{
These functions test predicates on unique structures in a glycan structure vector,
taking advantage of hash-based deduplication to avoid redundant computation.
Similar to purrr predicate functions, but optimized for glycan structure vectors.
}
\details{
These functions only evaluate \code{.p} once for each unique structure, making them
much more efficient than applying \code{.p} to each element individually when there
are duplicate structures.

\strong{Return Values:}
\itemize{
\item \code{ssome()}: Returns \code{TRUE} if at least one unique structure satisfies the predicate
\item \code{severy()}: Returns \code{TRUE} if all unique structures satisfy the predicate
\item \code{snone()}: Returns \code{TRUE} if no unique structures satisfy the predicate
}
}
\examples{
# Create a structure vector with duplicates
core1 <- o_glycan_core_1()
core2 <- n_glycan_core()
structures <- c(core1, core2, core1)  # core1 appears twice

# Test if some structures have more than 5 vertices
ssome(structures, function(g) igraph::vcount(g) > 5)

# Test if all structures have at least 3 vertices
severy(structures, function(g) igraph::vcount(g) >= 3)

# Test if no structures have more than 20 vertices
snone(structures, function(g) igraph::vcount(g) > 20)

# Use purrr-style lambda functions
ssome(structures, ~ igraph::vcount(.x) > 5)
severy(structures, ~ igraph::vcount(.x) >= 3)
snone(structures, ~ igraph::vcount(.x) > 20)

}
