% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_holes.R
\name{load_holes}
\alias{load_holes}
\alias{get_player_scorecards}
\title{Load Hole-by-Hole Scoring}
\usage{
load_holes(
  year = as.integer(format(Sys.Date(), "\%Y")),
  tournament = NULL,
  top_n = NULL,
  tour = "pga"
)

get_player_scorecards(event_id, athlete_id)
}
\arguments{
\item{year}{Season year (e.g., 2026). Defaults to current year.}

\item{tournament}{Tournament identifier - either event_id or partial name match.}

\item{top_n}{Number of top finishers to include. Default NULL returns all.}

\item{tour}{Tour identifier. Currently supports "pga" (default).}

\item{event_id}{ESPN event identifier (for legacy function)}

\item{athlete_id}{ESPN athlete identifier (for legacy function)}
}
\value{
A tibble with hole-by-hole data including:
  \itemize{
    \item \code{player_id}: ESPN athlete ID
    \item \code{player_name}: Player display name
    \item \code{round}: Round number (1-4)
    \item \code{hole}: Hole number (1-18)
    \item \code{par}: Par for the hole
    \item \code{score}: Player's score on the hole
    \item \code{score_type}: BIRDIE, PAR, BOGEY, EAGLE, etc.
    \item \code{tournament_id}: Event ID
  }

A tibble with hole-by-hole scoring data
}
\description{
Retrieves hole-by-hole scoring data for tournaments.
}
\section{Functions}{
\itemize{
\item \code{get_player_scorecards()}: Legacy function for backwards compatibility

}}
\examples{
\donttest{
# Load hole-by-hole for top 10 at Sony Open
holes <- load_holes(2026, "Sony", top_n = 10)
}
}
