% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goose_essentials.R
\name{goose_give_sample}
\alias{goose_give_sample}
\title{Share R Object Structure with Goose}
\usage{
goose_give_sample(object, name = NULL, rows = 5, save_to_memory = TRUE)
}
\arguments{
\item{object}{An R object (data.frame, matrix, tibble, list, etc.)}

\item{name}{Optional custom name for the object. Defaults to the object's name.}

\item{rows}{Number of sample rows to include (default: 5)}

\item{save_to_memory}{Whether to save to Goose memory (default: TRUE)}
}
\value{
Invisible NULL. Prints object summary and saves to memory.
}
\description{
Captures the structure and sample values of an R object and saves it
in a format that Goose can understand and reference when providing code.
This enables Goose to write accurate code that references actual column names
and understands data types.
}
\examples{
\dontrun{
# Share a data frame with Goose
goose_give_sample(mtcars)

# Share with custom name
goose_give_sample(iris, "flower_data")

# Share just structure without saving
goose_give_sample(my_model, save_to_memory = FALSE)
}

}
