% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int_period-class.R
\name{int_period_class}
\alias{int_period_class}
\alias{as_int_period.default}
\alias{as_int_period.integer}
\alias{as_int_period.double}
\alias{new_int_period}
\alias{is_int_period}
\alias{as_int_period}
\title{Integer-period class (Experimental)}
\usage{
\method{as_int_period}{default}(x, n = 1L, ...)

\method{as_int_period}{integer}(x, n = 1L, ...)

\method{as_int_period}{double}(x, n = 1L, ...)

new_int_period(x = integer(), n = 1L)

is_int_period(xx)

as_int_period(x, n, ...)
}
\arguments{
\item{x, xx}{\R objects.

For \code{as_int_period()} this is the object to be coerced.

For \code{new_int_period()} this represents the number of \code{n} integer periods from 0.

\code{double} vectors will be converted via \code{as.integer(floor(x))}.}

\item{n}{\verb{[integer]}

Number of integers that are being grouped. Must be greater than 0.}

\item{...}{Not currently used.}
}
\value{
A \verb{<grates_int_period>} object.
}
\description{
\verb{<grates_int_period>} objects represent groupings of \code{n} consecutive integers
from \code{0}.
}
\details{
\code{as_int_period()} is a generic for coercing input into \verb{<grates_int_period>}
objects. For numeric input it coerces it's input \code{x} first via
\code{x <- as.integer(floor(x))} and then via integer division by \code{n} (i.e.
\code{x \%/\% n}).

\code{new_int_period()} is a minimal constructor for \verb{<grates_period>}
objects aimed at developers. It takes, as input, the number of integer
periods and the value of \code{n}.
}
\examples{

# coercion
as_int_period(1:10, n = 3)

# direct construction
stopifnot(
    identical(
        as_int_period(1:10, n = 3),
        new_int_period(c(0, 0, 1, 1, 1, 2, 2, 2, 3, 3), n = 3)
    )
)



}
